/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import org.mockserver.echo.http.EchoServer;

@ChannelHandler.Sharable
public class EchoServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final EchoServer.Error error;

    public EchoServerHandler(EchoServer.Error error) {
        this.error = error;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        HttpResponseStatus responseStatus = HttpResponseStatus.OK;
        if (request.uri().equals("/not_found")) {
            responseStatus = HttpResponseStatus.NOT_FOUND;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((ByteBuf)request.content()));
        response.headers().add(request.headers());
        if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)(response.content().readableBytes() * 2));
        } else if (this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)(response.content().readableBytes() / 2));
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        }
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        ctx.writeAndFlush((Object)response);
        if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH || this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

