/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.generic.session.impl;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorExceptionValues;
import be.ehealth.technicalconnector.generic.session.GenericService;
import be.ehealth.technicalconnector.validator.SessionValidator;
import be.ehealth.technicalconnector.ws.GenericWsSender;
import be.ehealth.technicalconnector.ws.ServiceFactory;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import java.net.URL;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GenericServiceImpl
implements GenericService {
    private SessionValidator sessionValidator;

    public GenericServiceImpl(SessionValidator sessionValidator) {
        this.sessionValidator = sessionValidator;
    }

    @Override
    public String sendXML(String payload, URL endpoint) throws TechnicalConnectorException {
        return this.sendXML(payload, endpoint.toExternalForm(), null);
    }

    @Override
    public String sendXML(String payload, URL endpoint, String soapAction) throws TechnicalConnectorException {
        return this.sendXML(payload, endpoint.toExternalForm(), soapAction);
    }

    @Override
    public String sendXML(String payload, String endpoint) throws TechnicalConnectorException {
        return this.sendXML(payload, endpoint, null);
    }

    @Override
    public String sendXML(String payload, String endpoint, String soapAction) throws TechnicalConnectorException {
        GenericWsSender sender = ServiceFactory.getGenericWsSender();
        if (this.sessionValidator.validateSession()) {
            GenericRequest request = new GenericRequest();
            request.setEndpoint(endpoint);
            request.setSoapAction(soapAction);
            request.setCredentialFromSession(TokenType.SAML);
            request.setPayload(payload);
            try {
                return sender.send(request).asString();
            }
            catch (SOAPException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Node sendDocument(Document payload, URL endpoint) throws TechnicalConnectorException {
        return this.sendDocument(payload, endpoint.toExternalForm(), null);
    }

    @Override
    public Node sendDocument(Document payload, URL endpoint, String soapAction) throws TechnicalConnectorException {
        return this.sendDocument(payload, endpoint.toExternalForm(), soapAction);
    }

    @Override
    public Node sendDocument(Document payload, String endpoint) throws TechnicalConnectorException {
        return this.sendDocument(payload, endpoint, null);
    }

    @Override
    public Node sendDocument(Document payload, String endpoint, String soapAction) throws TechnicalConnectorException {
        GenericWsSender sender = ServiceFactory.getGenericWsSender();
        if (this.sessionValidator.validateSession()) {
            GenericRequest request = new GenericRequest();
            request.setEndpoint(endpoint);
            request.setSoapAction(soapAction);
            request.setCredentialFromSession(TokenType.SAML);
            request.setPayload(payload);
            try {
                return sender.send(request).asNode();
            }
            catch (SOAPException e) {
                throw new TechnicalConnectorException(TechnicalConnectorExceptionValues.ERROR_WS, (Throwable)e, e.getMessage());
            }
        }
        return null;
    }

    @Override
    public GenericResponse send(GenericRequest request) throws TechnicalConnectorException {
        GenericWsSender sender = ServiceFactory.getGenericWsSender();
        return sender.send(request);
    }
}

