﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.mycarenet.attestv2.domain;
using be.fgov.ehealth.mycarenet.attest.protocol.v2;
using be.fgov.ehealth.standards.kmehr.mycarenet.schema.v1;
using ikvm.extensions;
using javax.xml.parsers;
using java.util;
using org.w3c.dom;
using be.ehealth.technicalconnector.config;
using be.ehealth.businessconnector.mycarenet.attestv2.builders;
using be.ehealth.technicalconnector.utils;
using be.ehealth.businessconnector.mycarenet.attestv2.session;
using be.ehealth.technicalconnector.adapter;
using be.fgov.ehealth.standards.kmehr.mycarenet.id.v1;
using be.fgov.ehealth.standards.kmehr.mycarenet.cd.v1;
using be.fgov.ehealth.standards.kmehr.mycarenet.dt.v1;
using java.io;
using javax.xml.xpath;
using be.ehealth.business.mycarenetdomaincommons.domain;

namespace be.ehealth.businessconnector.attestv2.helper
	
{
	/**
     * Utilities class needed for cancel and send for eAttest v2 integration tests
     *
     * @author EHP
     *
     */
	public class AttestIntegrationTestHelper
	{
		
		private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		
		public AttestIntegrationTestHelper()
		{
		}
		
		public SendAttestBuilderRequest buildRequest(be.ehealth.businessconnector.mycarenet.attestv2.domain.InputReference inputReference, String scenarioName, String ssin, String profession) {
			Ssin ssinValue = new Ssin(ssin);
			org.joda.time.DateTime dateReference = new org.joda.time.DateTime();
			RequestObjectBuilder builder = RequestObjectBuilderFactory.getRequestObjectBuilder();
			Kmehrmessage kmehrRequest = buildKmehrmessage(scenarioName, ssin, profession);
			SendAttestBuilderRequest attestBuilderRequest = builder.buildSendAttestationRequest(true, inputReference, ssinValue, dateReference, kmehrRequest);
			ConnectorXmlUtils.dump(attestBuilderRequest.getSendTransactionRequest());
			AttestService service = AttestSessionServiceFactory.getAttestService();

			return attestBuilderRequest;

		}
		
		public CancelAttestBuilderRequest buildRequest(be.ehealth.businessconnector.mycarenet.attestv2.domain.InputReference inputReference, String scenarioName, String ssin,  String profession, String ack) {
			Ssin ssinValue = new Ssin(ssin);
			org.joda.time.DateTime dateReference = new org.joda.time.DateTime();
			RequestObjectBuilder builder = RequestObjectBuilderFactory.getRequestObjectBuilder();
			Kmehrmessage kmehrRequest = buildKmehrmessage(scenarioName, ssin, profession,ack);
			CancelAttestBuilderRequest attestBuilderRequest = builder.buildCancelAttestationRequest(true, inputReference, ssinValue, dateReference, kmehrRequest);
			ConnectorXmlUtils.dump(attestBuilderRequest.getCancelAttestationRequest());

            return attestBuilderRequest;

		}

		public  Kmehrmessage buildKmehrmessage(String scenarioName, String ssin, String profession) {
			Map velocityContext = fillContext(ssin);
			return getKmehrMessage(scenarioName, profession, velocityContext);
		}

		public  Kmehrmessage buildKmehrmessage(String scenarioName, String ssin, String profession, String ack) {
			Map velocityContext = fillContext(ssin);
			velocityContext.put("invoicingNumber", ack);

			return getKmehrMessage(scenarioName, profession, velocityContext);
		}

		private Map fillContext(String ssin) {
			Map velocityContext = new HashMap();
			velocityContext.put("today", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
			velocityContext.put("yesterday", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime().minusDays(1)));
			velocityContext.put("ssin", ssin);
			velocityContext.put("patient", ssin);
			return velocityContext;
		}

		private Kmehrmessage getKmehrMessage(String scenarioName, String profession, Map velocityContext) {
			String kmerh = TemplateEngineUtils.generate(velocityContext, ".\\scenarios.\\requests\\"  + profession  + "\\" +  scenarioName + "_request" + ".xml");
			MarshallerHelper kmehrRequestMarshaller = new MarshallerHelper(typeof(Kmehrmessage), typeof(Kmehrmessage));
			Kmehrmessage request = (Kmehrmessage) kmehrRequestMarshaller.toObject(kmerh);
			
			return request;
		}

		public String buildExpectedSendAttestResponse(SignedEncryptedBuilderResponse builderResponse, String inputReference,String profession,String oa,String scenarioName)  {
			Map velocityContext = new HashMap();
			velocityContext.put("requestId", "18334780004" + "." + inputReference);
			replaceDateTimes(builderResponse, velocityContext);
			return TemplateEngineUtils.generate(velocityContext, ".\\scenarios.\\expected.\\" + profession  +  ".\\" + oa + ".\\" + scenarioName + "_response" + ".xml");
		}

		public String buildExpectedCancelAttestResponse(SignedBuilderResponse builderResponse, String inputReference, String scenarioName, String oa, String profession)  {
			Map velocityContext = new HashMap();
			velocityContext.put("requestId", "18334780004" + "." + inputReference);
			replaceDateTimes(builderResponse, velocityContext);
			return TemplateEngineUtils.generate(velocityContext, ".\\scenarios.\\expected.\\" + profession  +  ".\\" + oa + ".\\" + scenarioName + "_response" + ".xml");
		}

		private void replaceDateTimes(SignedBuilderResponse builderResponse, Map velocityContext)  {
			velocityContext.put("today", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
			velocityContext.put("responseTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getTime()));
			velocityContext.put("requestTime",  new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getRequest().getTime()));

			if (builderResponse.getSendTransactionResponse().getKmehrmessage() != null) {
				velocityContext.put("headerTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getKmehrmessage().getHeader().getTime()));
				java.util.List folders = builderResponse.getSendTransactionResponse().getKmehrmessage().getFolders();
				for (int i=0; i<folders.size(); i++) {
					java.util.List transactions = ((FolderType) folders.get(i)).getTransactions();
					for (int j=0; j<transactions.size(); j++) {
						TransactionType transaction = (TransactionType) transactions.get(j);
						velocityContext.put("transactionTime" + ((IDKMEHR) transaction.getIds().get(0)).getValue(), new XmlTimeAdapter().marshal(transaction.getTime()));
					}
				}
			}
		}

		private void replaceDateTimes(SignedEncryptedBuilderResponse builderResponse, Map velocityContext)  {
			velocityContext.put("today", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime()));
			velocityContext.put("yesterday", org.joda.time.format.DateTimeFormat.forPattern("yyyy-MM-dd").print(new org.joda.time.DateTime().minusDays(1)));
			velocityContext.put("responseTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getTime()));
			velocityContext.put("requestTime",  new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getResponse().getRequest().getTime()));

			if (builderResponse.getSendTransactionResponse().getKmehrmessage() != null) {
				velocityContext.put("headerTime", new XmlTimeAdapter().marshal(builderResponse.getSendTransactionResponse().getKmehrmessage().getHeader().getTime()));
				java.util.List folders = builderResponse.getSendTransactionResponse().getKmehrmessage().getFolders();
				for (int i=0; i<folders.size(); i++) {
					java.util.List transactions = ((FolderType) folders.get(i)).getTransactions();
					for (int j=0; j<transactions.size(); j++) {
						TransactionType transaction = (TransactionType) transactions.get(j);
						velocityContext.put("transactionTime" + ((IDKMEHR) transaction.getIds().get(0)).getValue(), new XmlTimeAdapter().marshal(transaction.getTime()));
					}
				}
			}
		}

		public String getInvoiceNumber(SendAttestationResponse sendResponse, SendAttestBuilderRequest builderRequest) {
            ConnectorXmlUtils.dump(sendResponse);
            ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();
    
            SignedEncryptedBuilderResponse builderCancelResponse = responseBuilder.handleSendResponseType(sendResponse, builderRequest);
    
            return ((TextType) ((ContentType)((ItemType) ((TransactionType) ((FolderType) builderCancelResponse.getSendTransactionResponse().getKmehrmessage().getFolders().get(0))
            .getTransactions().get(0)).getItem().get(0)).getContents().get(0)).getTexts().get(0)).getValue();
        }

		public SignedBuilderResponse getBuildCancelAttestResponse(CancelAttestationResponse response, CancelAttestationRequest request)  {
			ConnectorXmlUtils.dump(response);
			ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();

			return responseBuilder.handleCancelResponseType(response, request);
		}

		public SignedEncryptedBuilderResponse getBuildSendAttestResponse(SendAttestationResponse response, SendAttestBuilderRequest builderRequest)  {
			ConnectorXmlUtils.dump(response);
			ResponseObjectBuilder responseBuilder = ResponseObjectBuilderFactory.getResponseObjectBuilder();

			return responseBuilder.handleSendResponseType(response, builderRequest);
		}
	}
}
