package be.ehealth.businessconnector.test.mediprima.session;

import be.cin.nip.async.generic.Post;
import be.cin.nip.async.generic.PostResponse;
import be.ehealth.businessconnector.test.genericasync.helper.PostTestHelper;
import be.ehealth.technicalconnector.utils.TemplateEngineUtils;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;


/**
 * <p>Runs the post requests for the integration test scenarios specified by MyCareNet. You can of course add your own test files.</p>
 *    
 * <p>For the scenarios 7 to 10 requests to be valid the following editing must be done to the supplied 920000 test files before performing a post operation.
 * The structure of the 920000 message can be found in http://www.inami.fgov.be/SiteCollectionDocuments/instructions_facturation_electronique.pdf  </p>
 * The templating engine is used to edit the template test files located in test resources folder <code>/invoicing/request/"</code>
 * </p>
 *     

 * <ul>
 *  <li>Change the <code>nihii</code> with the n° of your choice. It will be set by the templating engine in:</li>
 *  <ul>
 *            <li>record 10 + 20 + 25 + 80 + 90, zone 14 every time</li>
 *            <li>record 50 et 51, zone 15</li>
 *  </ul>   
 *  <ul>
 *   <li>increment <code>sendingNumber</code>: It will be set in record 10, zone 7 (start with 001, 002, 003, and so on)</li>
 *   <li>The date of the day is set in the <code>invoiceDate</code>, record 10, zone 25-26 and also in record 51 zone 55</li>
 *  </ul>
 *
 * <ul>
 *  <li>Perform a tariff consultation as defined in the scenario.</li>
 * </ul> 
 *  From the response of this tariff consultation:
 * <ul>
 *  <li>Retrieve the agreement number (see the financialcontract item) and set it in <code>agreementNumber</code>: the value will be set in record 51, zone 42-45.</li>
 *  <li>Retrieve the encounter date and set it in <code>agreementNumber</code>: the value will be set in record 50, zone 5 and also 6a-6b.</li>
 *  <li>Put the month of the encounter date in in <code>yearMonthEncounterDate</code>:  the value will be set record 10, zone 23.</li>
 * </ul>
 * 
 * @author EHP
 */
@RunWith(Parameterized.class)
public class MediprimaInvoicingPostGenericAsyncIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(MediprimaInvoicingPostGenericAsyncIntegrationTest.class);

    private static final String PROJECT_NAME = "mediprima.invoicing";
    private final String sendingNumber;
    private final String nihii;
    private final String encounterDate;
    private final String agreementNumber;
    private final String yearMonthEncounterDate;
    private final String filename;
    private final String r10CheckDigits;
    private final String r90CheckDigits;


    @Rule
    public SessionRule rule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.mediprima.test.properties").build();
    
    private PostTestHelper testHelper = PostTestHelper.Builder()
            .projectName(PROJECT_NAME)
            .isTest(false)
            .withXades(true)
            .build();

    @Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        Collection<Object[]> testData = new ArrayList<Object[]>();
        
        // Business errors
        testData.add(new Object[]{"TFAD6Sc01", null, null, null, null, null, null, null});
        testData.add(new Object[]{"TFAD6Sc02", null, null, null, null, null, null, null});
        testData.add(new Object[]{"TFAD6Sc03", null, null, null, null, null, null, null});
        testData.add(new Object[]{"TFAD6Sc04", null, null, null, null, null, null, null});
        testData.add(new Object[]{"TFAD6Sc05", null, null, null, null, null, null, null});
        testData.add(new Object[]{"TFAD6Sc06", null, null, null, null, null, null, null});

        // Happy flow
        testData.add(new Object[]{"TFAD6Sc07", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"});
        testData.add(new Object[]{"TFAD6Sc08", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"});
        testData.add(new Object[]{"TFAD6Sc09", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"});
        testData.add(new Object[]{"TFAD6Sc10", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 09 check digits"});

        return testData;
    }

    public MediprimaInvoicingPostGenericAsyncIntegrationTest(String filename, String sendingNumber, String nihii, String encounterDate,
                                                             String agreementNumber, String yearMonthEncounterDate,
                                                             String r10CheckDigits, String r90CheckDigits) {
        this.filename = filename;
        this.sendingNumber = sendingNumber;
        this.nihii = nihii;
        this.encounterDate = encounterDate;
        this.agreementNumber = agreementNumber;
        this.yearMonthEncounterDate = yearMonthEncounterDate;
        this.r10CheckDigits = r10CheckDigits;
        this.r90CheckDigits = r90CheckDigits;
    }

    @Test
    public void performPostRequestTest() throws Exception {
        String invoice = generateFileContentFromFileTemplate();

        LOG.debug("Invoice content: {0}" +  invoice);
        performPost(invoice.getBytes(), PROJECT_NAME, "ECM-HCPFAC");
    }

    private String generateFileContentFromFileTemplate() {
        Map<String, Object> velocityContext = new HashMap<String, Object>();

        velocityContext.put("sendingNumber", sendingNumber);
        velocityContext.put("nihii", nihii);
        velocityContext.put("invoiceDate", DateTimeFormat.forPattern("yyyyMMdd").print(new DateTime()));
        velocityContext.put("encounterDate", encounterDate);
        velocityContext.put("agreementNumber", agreementNumber);
        velocityContext.put("yearMonthEncounterDate", yearMonthEncounterDate);
        velocityContext.put("r10CheckDigits", r10CheckDigits);
        velocityContext.put("r90CheckDigits", r90CheckDigits);


        return TemplateEngineUtils.generate(velocityContext, "/invoicing/request/" + filename);
    }


    public void performPost(byte[] contentBytes, String serviceName, String messageName) throws Exception {
        Post post = testHelper.buildPostRequest(contentBytes, messageName);

        PostResponse responsePost = testHelper.post(serviceName, post);

        testHelper.validateResponse(responsePost);
    }
}
