/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.utils;

import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.cms.CMSTypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Streams {
    private static final Logger LOGGER = LoggerFactory.getLogger(Streams.class);
    public static final Integer DEFAULT_BUFFER_SIZE = 4096;

    private Streams() {
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) {
        Preconditions.checkNotNull(inputStream, "The given input stream is null");
        Preconditions.checkNotNull(outputStream, "The given output stream is null");
        try {
            int bytesRead;
            byte[] buffer = new byte[DEFAULT_BUFFER_SIZE.intValue()];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid streams. Unable to copy input to output.", e);
        }
        finally {
            Streams.closeQuietly(inputStream);
            Streams.closeQuietly(outputStream);
        }
    }

    public static byte[] getBytes(InputStream inputStream) {
        try {
            int channel;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((channel = inputStream.read()) >= 0) {
                outputStream.write(channel);
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid input. Unable to get bytes from input stream.", e);
        }
    }

    public static InputStream fromBytes(byte[] source) {
        return new ByteArrayInputStream(source);
    }

    public static InputStream fromOutputStream(OutputStream outputStream) {
        return new ByteArrayInputStream(((ByteArrayOutputStream)outputStream).toByteArray());
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ignored) {
            LOGGER.trace("Closeable already closed. Ignore.", (Throwable)ignored);
        }
    }

    public static void drain(CMSTypedStream stream) {
        try {
            stream.drain();
        }
        catch (IOException ignored) {
            LOGGER.trace("Stream already drained. Ignore.", (Throwable)ignored);
        }
    }
}

