/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mediprima.session;

import be.ehealth.businessconnector.test.genericasync.helper.GetAndConfirmTestHelper;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Arrays;
import java.util.List;


/**
 * <p>Tests to check and document the asynchronous call flow of the operations get and confirm of the MediPrima invoicing service.<p>
 * 
 * <p>Not that the MediPrima service works with message id references (not with hashes).</p>
 * 
 * <p>The business content of the returned invoicing files is not checked.</p>
 *
 * @author EHP
 */
public class MediprimaInvoicingGetAndConfirmGenericAsyncIntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(MediprimaInvoicingGetAndConfirmGenericAsyncIntegrationTest.class);

    private static final String PROJECT_NAME = "mediprima.invoicing";
    private static final String OUTPUT_FILE_EXTENSION = ".txt";
    private static final String OUTPUT_DIR = "invoicingSendFiles";
    private static final int MAX_MESSAGES = 100;
    
    private final List<String> messageNames = Arrays.asList("ECM-HCPFAC", "ECM-HCPVWR");

    private GetAndConfirmTestHelper testHelper;


    @Before
    public void initTestHelper() throws ConnectorException {
        testHelper = GetAndConfirmTestHelper.Builder()
                .projectName(PROJECT_NAME)
                .messageNames(messageNames)
                .maxMessages(MAX_MESSAGES)
                .outputFileExtension(OUTPUT_FILE_EXTENSION)
                .outputDir(OUTPUT_DIR)
                .build();
    }

    @Rule
    public SessionRule sessionRule = SessionRule.withActiveSession().baseOn("/be.ehealth.businessconnector.mediprima.test.properties").build();

    @Test
    public void getTest() throws Exception {
        testHelper.performGetAndConfirm(false);
    }

    @Test
    public void getAndConfirmTest() throws Exception {
        testHelper.performGetAndConfirm(true);
    }

    /**
     * To run this test, supply a list of TAckResponse references you want ensure they are no longer returned
     * by the service (typically, after confirming TAck responses).
     */
    @Test
    public void checkIfTAckResponsesWithSameReferencesAreStillReturned() throws Exception {

        /**** Add the references to be checked to this list ***/
        List<String> tAckResponseReferences = Arrays.asList();
        /******************************************************/
        
        testHelper.checkIfTAckResponsesWithSameReferencesAreStillReturned(tAckResponseReferences);
    }

    /**
     * To run this test, supply a list of MsgResponse references you want ensure they are no longer returned
     * by the service (typically, after confirming TAck responses).
     */
    @Test
    public void checkIfMessagesWithSameReferencesAreStillReturned() throws Exception {

        /**** Add the references to be checked to this list ***/
         List<String> msgResponseReferences = Arrays.asList();
        /******************************************************/
        
        testHelper.checkIfMessagesWithSameReferencesAreStillReturned(msgResponseReferences);
    }
}
