/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.domain;

import be.ehealth.businessconnector.chapterIV.domain.ChapterIVReferences;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;


/**
 * Test of the serializable of an object with a ChapterIVReference object
 * 
 * @author eh058
 * 
 * @since
 * 
 */
public class ChapterIVReferencesTest {

    @Test
    public void test() {
        String test = "test";
        byte[] serializedDocument = SerializationUtils.serialize(test);
        String deserializedDocument = (String) SerializationUtils.deserialize(serializedDocument);
        Assert.assertEquals(test, deserializedDocument);
    }

    @Test
    public void testSerializeObject() throws Exception {
        ChapterIVReferences response = new ChapterIVReferences(false);
        byte[] serializedDocument = SerializationUtils.serialize(response);
        ChapterIVReferences deserializedDocument = (ChapterIVReferences) SerializationUtils.deserialize(serializedDocument);
        Assert.assertEquals(response, deserializedDocument);
    }

}
