/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.domain.responses;

import be.ehealth.businessconnector.therlink.domain.responses.TherapeuticLinkResponseError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Acknowledge {
    private boolean isComplete;
    private List<TherapeuticLinkResponseError> listOfErrors;

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public List<TherapeuticLinkResponseError> getListOfErrors() {
        if (this.listOfErrors == null) {
            this.listOfErrors = new ArrayList<TherapeuticLinkResponseError>();
        }
        return this.listOfErrors;
    }

    public void setListOfErrors(List<TherapeuticLinkResponseError> listOfErrors) {
        this.listOfErrors = listOfErrors;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)("Complete? : " + this.isComplete));
        if (this.listOfErrors != null) {
            Iterator<TherapeuticLinkResponseError> it = this.listOfErrors.iterator();
            while (it.hasNext()) {
                TherapeuticLinkResponseError next = it.next();
                builder.append((Object)"[");
                builder.append((Object)("Error code : " + next.getErrorCode()));
                builder.append((Object)("ErrorDescription : " + next.getErrorDescription()));
                builder.append((Object)"]");
                if (!it.hasNext()) continue;
                builder.append((Object)", ");
            }
        }
        return builder.toString();
    }

    public static class Builder {
        private Acknowledge ack = new Acknowledge();

        public Builder withComplete(boolean complete) {
            this.ack.setComplete(complete);
            return this;
        }

        public Builder addError(TherapeuticLinkResponseError error) {
            this.ack.getListOfErrors().add(error);
            return this;
        }

        public Acknowledge build() {
            return this.ack;
        }
    }
}

