/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.technicalconnector.ra.domain;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.fgov.ehealth.technicalconnector.ra.domain.Actor;
import be.fgov.ehealth.technicalconnector.ra.domain.CertificateIdentifier;
import be.fgov.ehealth.technicalconnector.ra.domain.ContactData;
import be.fgov.ehealth.technicalconnector.ra.domain.Request;
import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class ContractRequest
extends Request
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ContactData contactData;
    private Actor signer;
    private CertificateIdentifier certificateIdentifier;

    private ContractRequest(Builder builder) throws TechnicalConnectorException {
        this.contactData = builder.contactData;
        this.signer = builder.signer;
        this.certificateIdentifier = builder.certificateIdentifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ContactData getContactData() {
        return this.contactData;
    }

    public Actor getSigner() {
        return this.signer;
    }

    public CertificateIdentifier getCertificateIdentifier() {
        return this.certificateIdentifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractRequest that = (ContractRequest)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.getContactData(), (Object)that.getContactData()).append((Object)this.getSigner(), (Object)that.getSigner()).append((Object)this.getCertificateIdentifier(), (Object)that.getCertificateIdentifier()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getContactData()).append((Object)this.getSigner()).append((Object)this.getCertificateIdentifier()).toHashCode();
    }

    public static final class Builder {
        private ContactData contactData;
        private Actor signer;
        private CertificateIdentifier certificateIdentifier;

        private Builder() {
        }

        public Builder contactData(ContactData contactData) {
            this.contactData = contactData;
            return this;
        }

        public Builder signer(Actor signer) {
            this.signer = signer;
            return this;
        }

        public Builder certificateIdentifier(CertificateIdentifier certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public ContractRequest build() throws TechnicalConnectorException {
            return new ContractRequest(this);
        }
    }
}

