/**
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.mycarenet.attestv2.builders.impl;

import java.io.ByteArrayInputStream;

import be.ehealth.businessconnector.mycarenet.attestv2.builders.impl.ResponseObjectBuilderImpl;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.w3._2005._05.xmlmime.Base64Binary;

import be.cin.encrypted.BusinessContent;
import be.ehealth.businessconnector.mycarenet.attestv2.builders.ResponseObjectBuilder;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.SendAttestBuilderRequest;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.SignedBuilderResponse;
import be.ehealth.businessconnector.mycarenet.attestv2.domain.SignedEncryptedBuilderResponse;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.etee.Crypto;
import be.ehealth.technicalconnector.service.etee.domain.UnsealedData;
import be.ehealth.technicalconnector.utils.ConnectorXmlUtils;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.ehealth.technicalconnector.utils.SessionUtil;
import be.fgov.ehealth.messageservices.mycarenet.core.v1.SendTransactionResponse;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.CancelAttestationRequest;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.CancelAttestationResponse;
import be.fgov.ehealth.mycarenet.attest.protocol.v2.SendAttestationResponse;
import be.fgov.ehealth.mycarenet.commons.core.v3.BlobType;
import be.fgov.ehealth.mycarenet.commons.protocol.v3.ResponseReturnType;
import be.fgov.ehealth.technicalconnector.signature.domain.SignatureVerificationError;

/**
 * Test for class ResponseObjectBuilderImpl
 * @author EHP
 *
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({ConnectorXmlUtils.class,SessionUtil.class})
public class ResponseObjectBuilderImplTest {
    
    @Test
    public void handleSendResponseType() throws Exception {
        MarshallerHelper<SendAttestationResponse, SendAttestationResponse> helper = new MarshallerHelper<SendAttestationResponse, SendAttestationResponse>(SendAttestationResponse.class, SendAttestationResponse.class);
        SendAttestationResponse  sendAttestationResponse = new SendAttestationResponse();
        ResponseReturnType ret = new ResponseReturnType();
        BlobType blob = buildBlobType();
        ret.setDetail(blob);
        sendAttestationResponse.setReturn(ret);
        ResponseObjectBuilder responseObjectBuilder = new ResponseObjectBuilderImpl();
        PowerMock.mockStatic(ConnectorXmlUtils.class);
        PowerMock.mockStatic(SessionUtil.class);
        Crypto crypto = PowerMock.createMock(Crypto.class);
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        UnsealedData data = new UnsealedData();
        data.setContent(new ByteArrayInputStream("<EncryptedKnownContent><BusinessContent></BusinessContent></EncryptedKnownContent>".getBytes()));
        EasyMock.expect(crypto.unseal(EasyMock.anyObject(Crypto.SigningPolicySelector.class), EasyMock.anyObject(byte[].class))).andReturn(data);
        EasyMock.expect(SessionUtil.getHolderOfKeyCrypto()).andReturn(crypto);
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class),EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall() ;
        PowerMock.replayAll();

        SignedEncryptedBuilderResponse encryptedResponse = responseObjectBuilder.handleSendResponseType(sendAttestationResponse, new SendAttestBuilderRequest(null, null, new BusinessContent()));

        Assert.assertNotNull(encryptedResponse);
        Assert.assertNotNull(encryptedResponse);
        Assert.assertFalse(encryptedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(encryptedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }


        @Test
        public void handleCancelResponseTypeWithoutXadesValue() throws TechnicalConnectorException {
            CancelAttestationResponse  cancelAttestationResponse = new CancelAttestationResponse();
            ResponseReturnType responseReturnType = new ResponseReturnType();
            BlobType blob = buildBlobType();
            PowerMock.mockStatic(ConnectorXmlUtils.class);
            responseReturnType.setDetail(blob);
            Base64Binary xades = new Base64Binary();
        xades.setValue(null);
        responseReturnType.setXadesT(xades);
        cancelAttestationResponse.setReturn(responseReturnType);
        ResponseObjectBuilder responseObjectBuilder = new ResponseObjectBuilderImpl();
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class),EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall() ;
            PowerMock.replayAll();

        SignedBuilderResponse signedResponse = responseObjectBuilder.handleCancelResponseType(cancelAttestationResponse, new CancelAttestationRequest());

        Assert.assertNotNull(signedResponse);
        Assert.assertFalse(signedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(signedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }

    @Test
    public void handleCancelResponseTypeWithoutXades() throws TechnicalConnectorException {
        CancelAttestationResponse  cancelAttestationResponse = new CancelAttestationResponse();
        ResponseReturnType responseReturnType = new ResponseReturnType();
        BlobType blob = buildBlobType();
        PowerMock.mockStatic(ConnectorXmlUtils.class);
        responseReturnType.setDetail(blob);
        cancelAttestationResponse.setReturn(responseReturnType);
        ResponseObjectBuilder responseObjectBuilder = new ResponseObjectBuilderImpl();
        Class<SendTransactionResponse> clazz = SendTransactionResponse.class;
        EasyMock.expect(ConnectorXmlUtils.toObject(EasyMock.anyObject(byte[].class),EasyMock.anyObject(clazz.getClass()))).andReturn(new SendTransactionResponse());
        EasyMock.expectLastCall() ;
        PowerMock.replayAll();

        SignedBuilderResponse signedResponse = responseObjectBuilder.handleCancelResponseType(cancelAttestationResponse, new CancelAttestationRequest());

        Assert.assertNotNull(signedResponse);
        Assert.assertFalse(signedResponse.getSignatureVerificationResult().getErrors().isEmpty());
        Assert.assertTrue(signedResponse.getSignatureVerificationResult().getErrors().contains(SignatureVerificationError.SIGNATURE_NOT_PRESENT));
    }


    private BlobType buildBlobType() {
        BlobType blob = new BlobType();
        blob.setContentEncoding("none");
        blob.setContentType("text/xml");
        blob.setId("RSP-a41bba3d-88a6-491f-9063-865d082e6442");
        blob.setValue("<SendTransactionResponse></SendTransactionResponse>".getBytes());
        return blob;
    }
}
