/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.businessconnector.therlink.domain.requests;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.domain.OperationContext;
import be.ehealth.businessconnector.therlink.domain.TherapeuticLink;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TherapeuticLinkComplete
extends TherapeuticLink {
    private static final long serialVersionUID = 1L;
    private List<OperationContext> operationContext;

    public TherapeuticLinkComplete(Patient patient, HcParty hcParty, String type, List<OperationContext> operationContext) {
        super(patient, hcParty, type);
        this.operationContext = operationContext;
    }

    public List<OperationContext> getOperationContext() {
        return this.operationContext;
    }

    public void setOperationContext(List<OperationContext> operationContext) {
        this.operationContext = operationContext;
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy");
        builder.append((Object)"TherapeuticLink [HCP = ");
        builder.append((Object)this.hcParty);
        builder.append((Object)", Patient = ");
        builder.append((Object)this.patient);
        if (this.startDate != null) {
            builder.append((Object)", Startdate = ");
            builder.append((Object)df.format(this.startDate.toDateMidnight()));
        }
        if (this.endDate != null) {
            builder.append((Object)", Enddate = ");
            builder.append((Object)df.format(this.endDate.toDateMidnight()));
        }
        builder.append((Object)", Comment = ");
        builder.append((Object)this.comment);
        builder.append((Object)", Status = ");
        builder.append((Object)this.status);
        builder.append((Object)", OperationContexts = ");
        for (OperationContext oc : this.operationContext) {
            builder.append((Object)"[");
            builder.append((Object)oc.getOperation());
            builder.append((Object)"]");
        }
        builder.append((Object)"]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.operationContext == null ? 0 : ((Object)this.operationContext).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TherapeuticLinkComplete other = (TherapeuticLinkComplete)obj;
        return !(this.operationContext == null ? other.operationContext != null : !((Object)this.operationContext).equals(other.operationContext));
    }
}

