/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.config.domain.Duration;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.handler.wss4j.WSSecHeaderGeneratorWss4jImpl;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.SAMLToken;
import be.ehealth.technicalconnector.utils.ConfigurableFactoryHelper;
import java.util.concurrent.TimeUnit;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;

public abstract class AbstractWsSecurityHandler
extends AbstractSOAPHandler {
    public static final String PROP_WSSECHEADER_GENERATOR = "be.ehealth.technicalconnector.handler.wssecurity";
    private static final String PROP_SIGNATURE_TIMESTAMP_EXPIRES_TTL = "security.outgoing.message.timestamp.expires.ttl";
    private static final Configuration config = ConfigFactory.getConfigValidator();

    public WSSecHeaderGeneratorStep0 buildSignature() throws TechnicalConnectorException {
        ConfigurableFactoryHelper helper = new ConfigurableFactoryHelper(PROP_WSSECHEADER_GENERATOR, WSSecHeaderGeneratorWss4jImpl.class.getName());
        return (WSSecHeaderGeneratorStep0)helper.getImplementation();
    }

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        try {
            this.getLogger().debug("adding WS-Security header");
            this.addWSSecurity(context);
            context.getMessage().saveChanges();
        }
        catch (Exception e) {
            throw new ProtocolException((Throwable)e);
        }
        return true;
    }

    protected abstract void addWSSecurity(SOAPMessageContext var1) throws TechnicalConnectorException;

    protected abstract Logger getLogger();

    protected long getTimeStampTTL() {
        return config.getDurationProperty(PROP_SIGNATURE_TIMESTAMP_EXPIRES_TTL, 60L, TimeUnit.SECONDS).convert(TimeUnit.SECONDS);
    }

    public static interface WSSecHeaderGeneratorStep4 {
        public void sign(SignedParts ... var1) throws TechnicalConnectorException;
    }

    public static interface WSSecHeaderGeneratorStep3
    extends WSSecHeaderGeneratorStep4 {
        public WSSecHeaderGeneratorStep3 withSAMLToken(SAMLToken var1) throws TechnicalConnectorException;
    }

    public static interface WSSecHeaderGeneratorStep2
    extends WSSecHeaderGeneratorStep3 {
        public WSSecHeaderGeneratorStep3 withBinarySecurityToken(Credential var1) throws TechnicalConnectorException;
    }

    public static interface WSSecHeaderGeneratorStep1
    extends WSSecHeaderGeneratorStep2 {
        public WSSecHeaderGeneratorStep2 withTimeStamp(long var1, TimeUnit var3);

        public WSSecHeaderGeneratorStep2 withTimeStamp(Duration var1);
    }

    public static interface WSSecHeaderGeneratorStep0
    extends WSSecHeaderGeneratorStep2 {
        @Deprecated
        public WSSecHeaderGeneratorStep1 on(SOAPMessage var1) throws TechnicalConnectorException;

        public WSSecHeaderGeneratorStep1 on(SOAPMessageContext var1) throws TechnicalConnectorException;
    }

    public static enum SignedParts {
        BODY,
        TIMESTAMP,
        BST,
        SAML_ASSERTION;

    }
}

