package be.ehealth.technicalconnector.ws;

import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.service.sts.security.Credential;
import be.ehealth.technicalconnector.service.sts.security.impl.KeyStoreCredential;
import be.ehealth.technicalconnector.utils.DateUtils;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.ehealth.technicalconnector.ws.domain.GenericResponse;
import be.ehealth.technicalconnector.ws.domain.TokenType;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import java.io.IOException;

/**
 * The Class GenericWsCertSecured.
 *
 * @author EHP
 */
public class GenericWsCertSecuredIntegrationTest {


    @ClassRule
    public static SessionRule rule = SessionRule.withInactiveSession().build();

    /**
     * Use the Generic Certificate Secured Web Service method on the Platform Integration Test
     * <p>
     * This test includes the following main steps: <li>1. Set the URL to the web service end-point <li>2. Get the Certificate to use <li>3.
     * Get the payload <li>4. Send the message
     */
    @Test
    public void testSendCertSecuredString() throws Exception {
        Assert.assertNotNull(invoke().asString());
    }

    /**
     * Use the Generic Certificate Secured Web Service method on the Platform Integration Test
     * <p>
     * This test includes the following main steps: <li>1. Set the URL to the web service end-point <li>2. Get the Certificate to use <li>3.
     * Get the payload <li>4. Send the message
     */
    @Test
    public void testSendCertSecuredDOM() throws Exception {
        Assert.assertNotNull(invoke().asNode());
    }

    private GenericResponse invoke() throws Exception {
        GenericRequest request = new GenericRequest();

        // 1. Set the URL to the web service end-point
        request.setEndpoint(rule.getSessionProperty("test.secured.endpoint"));

        // 2. Get the Certificate to use
        Credential credential = new KeyStoreCredential(rule.getSessionProperty("test.keystore.location"), rule.getSessionProperty("test.keystore.alias"), rule.getSessionProperty("test.keystore.password"));
        request.setCredential(credential, TokenType.X509);
        request.setDefaultHandlerChain();

        // 3. Get the payload
        request.setPayload(getPayload());

        // 4. Send the message
        return be.ehealth.technicalconnector.ws.ServiceFactory.getGenericWsSender()
                .send(request);
    }

    /**
     * Builds the payload (string) for the request.
     */
    private String getPayload() throws IOException, TechnicalConnectorException {
        StringBuilder sb = new StringBuilder();
        sb.append("<CheckAccessControlRequest xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:v1\">");
        sb.append("<Message xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">Hello this is your captain speeking</Message>");
        sb.append("<Timestamp xmlns=\"urn:be:fgov:ehealth:platformintegrationconsumertest:types:v1\">");
        sb.append(DateUtils.printDateTime(new DateTime()));
        sb.append("</Timestamp>");
        sb.append("</CheckAccessControlRequest>");
        return sb.toString();

    }


}
