/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.test.chapterIV.testutil;

import be.ehealth.businessconnector.chapterIV.builders.KmehrBuilderFactory;
import be.ehealth.technicalconnector.utils.MarshallerHelper;
import be.fgov.ehealth.chap4.protocol.v1.ConsultChap4MedicalAdvisorAgreementResponse;
import be.fgov.ehealth.standards.kmehr.cd.v1.*;
import be.fgov.ehealth.standards.kmehr.dt.v1.TextType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDPATIENT;
import be.fgov.ehealth.standards.kmehr.schema.v1.ContentType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ItemType;
import be.fgov.ehealth.standards.kmehr.schema.v1.TransactionType;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

import java.io.InputStream;
import java.util.List;

import static be.ehealth.technicalconnector.utils.ConnectorIOUtils.*;


/**
 * test utilities.
 *
 * @author EHP
 */
public final class TestUtils {


    private static MarshallerHelper<ConsultChap4MedicalAdvisorAgreementResponse, ConsultChap4MedicalAdvisorAgreementResponse> helper = new MarshallerHelper<ConsultChap4MedicalAdvisorAgreementResponse, ConsultChap4MedicalAdvisorAgreementResponse>(ConsultChap4MedicalAdvisorAgreementResponse.class, ConsultChap4MedicalAdvisorAgreementResponse.class);

    private TestUtils() {
        throw new UnsupportedOperationException();
    }


    public static ConsultChap4MedicalAdvisorAgreementResponse mapToConsultResponseObject(String fileLocation) throws Exception {
        InputStream ios = null;
        try {
            ios = getResourceAsStream(fileLocation);
            return helper.toObject(ios);
        } finally {
            closeQuietly(ios);
        }
    }

    public static String getFileContents(String fileLocation) throws Exception {
        return convertStreamToString(getResourceAsStream(fileLocation));
    }



    public static void updateTransactionDate(FolderType folder, DateTime time) throws Exception {
        if (folder != null) {
            for (TransactionType transaction : folder.getTransactions()) {
                transaction.setDate(time);
                transaction.setTime(time);
            }
        }
    }
    
    public static void updateAgreementDate(FolderType folder, DateTime time) throws Exception {
        boolean cdAgreementStartDateFound = false;
        
        if (folder != null) {
            for (TransactionType transaction : folder.getTransactions()) {
                for(ItemType item : transaction.getItem()) {
                    for(CDITEM cdFromItem : item.getCds()) {
                        if(cdFromItem.getValue().equals("agreementstartdate")) {
                            cdAgreementStartDateFound = true;
                        }
                    }

                    for(ContentType content : item.getContents()){
                        if(cdAgreementStartDateFound){
                            content.setDate(time);
                            cdAgreementStartDateFound = false;
                        }
                    }
                }
            }
        }
    }
    
    public static void updateAuthor(FolderType folder) throws Exception {
        if (folder != null) {
            for (TransactionType transaction : folder.getTransactions()) {
                transaction.setAuthor( KmehrBuilderFactory.getKmehrBuilder().generateAuthor());
            }
        }
    }

    public static void updatePatient(FolderType folder, String inss) throws Exception {
        if (folder != null) {
            for (IDPATIENT idPatient : folder.getPatient().getIds()) {
                idPatient.setValue(inss);
            }
        }
    }

    public static void updateCNK(FolderType folder, String sv, String value) {
        if (folder != null && StringUtils.isNotBlank(sv) && StringUtils.isNotBlank(value)) {
            for (TransactionType transaction : folder.getTransactions()) {
                for (ItemType item : transaction.getItem()) {
                    boolean found = false;
                    for (CDITEM cd : item.getCds()) {
                        if (cd.getValue().equalsIgnoreCase("chapter4reference")) {
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        for (ContentType content : item.getContents()) {
                            for (CDCONTENT contentCD : content.getCds()) {
                                if (contentCD.getS() == CDCONTENTschemes.CD_DRUG_CNK) {
                                    contentCD.setSV(sv);
                                    contentCD.setValue(value);
                                }
                            }
                        }
                    }
                }

            }
        }
    }

    public static void updateReference(FolderType folder, String ticket) {
        if (folder != null && StringUtils.isNotBlank(ticket)) {
            for (TransactionType transaction : folder.getTransactions()) {
                for (ItemType item : transaction.getItem()) {
                    boolean found = false;
                    for (CDITEM cd : item.getCds()) {
                        if (cd.getValue().equalsIgnoreCase("careproviderreference")) {
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        for (ContentType content : item.getContents()) {
                            for (TextType text : content.getTexts()) {
                                text.setValue(ticket);
                            }
                        }
                    }
                }

            }
        }
    }



    public static DateTime extractDate(FolderType folder) {
        if (folder != null) {
            List<ItemType> items = folder.getTransactions().get(0).getItem();
            for (ItemType itemType : items) {
                if (CDITEMMAAvalues.CONSULTATIONSTARTDATE.value().equals(itemType.getCds().get(0).getValue()) && itemType.getCds().get(0).getS() == CDITEMschemes.CD_ITEM_MAA) {
                    return itemType.getContents().get(0).getDate();
                } else if (CDITEMMAAvalues.AGREEMENTSTARTDATE.value().equals(itemType.getCds().get(0).getValue()) && itemType.getCds().get(0).getS() == CDITEMschemes.CD_ITEM_MAA) {
                    return itemType.getContents().get(0).getDate();

                }
            }
        }
        return null;
    }



}
