package be.ehealth.business.test.mycarenetcommons.mappers;

import be.ehealth.business.mycarenetcommons.v3.mapper.RoutingMapper;
import be.ehealth.business.mycarenetdomaincommons.domain.CareReceiverId;
import be.ehealth.business.mycarenetdomaincommons.domain.Period;
import be.ehealth.business.mycarenetdomaincommons.domain.Routing;
import be.fgov.ehealth.mycarenet.commons.core.v3.RoutingType;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.mapstruct.factory.Mappers;

public class RoutingMapperTest {

    @Test
    public void mapRouting() {
        Routing routing = new Routing();

        DateTime dateTime = new DateTime();
        routing.setReferenceDate(dateTime);

        DateTime start = new DateTime();
        DateTime end = new DateTime();
        Period period = new Period(start, end);
        routing.setPeriod(period);

        String ssin = "dummy_ssin";
        String registrationNumber = "dummy_registrationnumber";
        String mutuality = "dummy_oa";
        CareReceiverId careReceiverId = new CareReceiverId(ssin, registrationNumber, mutuality);
        routing.setCareReceiver(careReceiverId);

        RoutingMapper mapper = Mappers.getMapper(RoutingMapper.class);
        RoutingType result = mapper.map(routing);

        Assert.assertEquals(dateTime, result.getReferenceDate());
        Assert.assertEquals(result.getReferenceDate(), routing.getReferenceDate());

        Assert.assertEquals(registrationNumber, result.getCareReceiver().getRegNrWithMut());
        Assert.assertEquals(result.getCareReceiver().getRegNrWithMut(), careReceiverId.getRegistrationNumberWithMutuality());

        Assert.assertEquals(mutuality, result.getCareReceiver().getMutuality());
        Assert.assertEquals(result.getCareReceiver().getMutuality(), careReceiverId.getMutuality());

        Assert.assertEquals(start, result.getPeriod().getStart());
        Assert.assertEquals(result.getPeriod().getStart(), period.getBegin());

        Assert.assertEquals(end, result.getPeriod().getEnd());
        Assert.assertEquals(result.getPeriod().getEnd(), period.getEnd());
    }

}
