package be.ehealth.technicalconnector.config.impl;

import be.fgov.ehealth.technicalconnector.tests.log4j.TestAppender;
import be.fgov.ehealth.technicalconnector.tests.utils.LoggingUtils;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;

import java.util.ArrayList;
import java.util.List;

import static org.hamcrest.CoreMatchers.startsWith;

public class ConfigurationModuleEhealthTimeTest {

    @Test
    public void init() throws Exception {
        LoggingUtils.bootstrap();
        TestAppender appender = LoggingUtils.getTestAppender();
        LoggingUtils.registerAppender(appender);
        new ConfigurationModuleEhealthTime().init(null);
        List<LoggingEvent> logEvents = appender.getLogEvents(ConfigurationModuleEhealthTime.class);
        Assert.assertThat(message(logEvents.get(0)), startsWith("eHealth time"));
        Assert.assertThat(message(logEvents.get(1)), startsWith("Local time"));
        Assert.assertThat(message(logEvents.get(2)), startsWith("diff with ehealth time"));
    }



    private static String message(LoggingEvent event) {
        return event.getMessage().toString();
    }

}