/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.util;


/**
 * Associations between hcparty types and therapeutic link types
 *
 * @author EHP
 */

public enum TherapeuticLinkTypeValues {
    /** */
    PERSMIDWIFE("persmidwife", "consultation", "referral"), //
    /** */
    PERSDENTIST("persdentist", "consultation", "referral"), //
    /** */
    PERSNURSE("persnurse", "nurseconsultation", "nursereferral"), //
    /** */
    PERSPHYSICIAN("persphysician", "gpconsultation", "gpreferral"), //
    /** */
    SPECIALIST("NOT_SUPPORTED", "specialistconsultation", "specialistreferral"),
    /** */
    PERSPHARMACIST("perspharmacist", "pharmacydelivery", "pharmacistreferral"),
    /** */
    ORGPHARMACY("orgpharmacy", "pharmacydelivery", "pharmacistreferral"),

    PERSPHYSIOTHERAPIST("persphysiotherapist", "consultation", "referral"),

    PERSPRACTICALNURSE("perspracticalnurse", "consultation", "referral"),

    PERSAUDIOLOGIST("persaudiologist", "consultation", "referral"),

    PERSTRUSSMAKER("perstrussmaker", "consultation", "referral"),

    PERSDIETICIAN("persdietician", "consultation", "referral"),


    PERSOCCUPATIONALTHERAPIST("persoccupationaltherapist", "consultation", "referral"),

    PERSBIOLOGIST("persbiologist", "consultation", "referral"),

    PERSLOGOPEDIST("perslogopedist", "consultation", "referral"),

    PERSORTHOPTIST("persorthoptist", "consultation", "referral"),

    PERSPODOLOGIST("perspodologist", "consultation", "referral"),

    PERSTECHNICIAN("perstechnician", "consultation", "referral"),

    PERSAUDICIAN("persaudician", "consultation", "referral"),

    PERSCLINICALORTHOPEDAGOGIST("persclinicalorthopedagogist", "consultation", "referral"),

    PERSCLINICALPSYCHOLOGIST("persclinicalpsychologist", "consultation", "referral"),

    PERSORALDENTALHYGIENIST("persoraldentalhygienist", "consultation", "referral");
    

    private String hcpartyType;

    private String therlinkType;

    private String referral;

    private TherapeuticLinkTypeValues(String hcpType, String therlinkType, String referral) {
        hcpartyType = hcpType;
        this.therlinkType = therlinkType;
        this.setReferral(referral);
    }


    /**
     * @return the hcpartyType
     */
    public String getHcpartyType() {
        return hcpartyType;
    }


    /**
     * @return the therlinkType
     */
    public String getTherlinkType() {
        return therlinkType;
    }


    /**
     * @return
     */
    public String getReferralType() {
        return referral;
    }


    /**
     * @return the referral
     */
    public String getReferral() {
        return referral;
    }


    /**
     * @param referral the referral to set
     */
    public void setReferral(String referral) {
        this.referral = referral;
    }

}
