/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.config.Configuration;
import be.ehealth.technicalconnector.handler.AbstractMimeHeaderManipulator;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentHandler
extends AbstractMimeHeaderManipulator {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentHandler.class);
    private static final String HEADER_NAME = "User-Agent";
    private static final String PROP_PARTS_REGEX = "be.ehealth.technicalconnector.handler.mimeheaders.user-agent.parts-regex";
    private static final String DEFAULT_PARTS_REGEX = "[a-zA-Z0-9]*\\/[0-9a-zA-Z-_.]*";
    private static final String KEY_USER_AGENT = "be.ehealth.technicalconnector.handler.mimeheaders.user-agent.prefix";
    private static final String CONNECTOR_USER_AGENT_PART_1 = "eHealthTechnical/";
    private static String CONNECTOR_USER_AGENT;
    private final Configuration config = ConfigFactory.getConfigValidator();
    private Pattern PREFIX_REGEX = Pattern.compile(System.getProperty("be.ehealth.technicalconnector.handler.mimeheaders.user-agent.parts-regex", "[a-zA-Z0-9]*\\/[0-9a-zA-Z-_.]*"));

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        this.addToHeader(context, HEADER_NAME, this.getUserAgent());
        return true;
    }

    private String getUserAgent() {
        StringBuilder sb = new StringBuilder();
        if (this.config.hasProperty(KEY_USER_AGENT)) {
            String prefix = this.config.getProperty(KEY_USER_AGENT);
            if (this.validPrefix(prefix)) {
                sb.append(prefix);
                sb.append(" ");
            } else {
                LOG.error("Invalid user-agent prefix [{}], skipping.", (Object)prefix);
            }
        }
        sb.append(CONNECTOR_USER_AGENT);
        return sb.toString();
    }

    private boolean validPrefix(String prefix) {
        String[] softwareVersionParts;
        for (String softwareVersionPart : softwareVersionParts = prefix.split(" ")) {
            if (this.PREFIX_REGEX.matcher(softwareVersionPart).matches()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = ConnectorIOUtils.getResourceAsStream("/application.properties");
            Properties applicationProps = new Properties();
            applicationProps.load(is);
            CONNECTOR_USER_AGENT = CONNECTOR_USER_AGENT_PART_1 + applicationProps.getProperty("application.version", "unknown");
        }
        catch (Exception e) {
            CONNECTOR_USER_AGENT = "eHealthTechnical/unknown";
            LOG.error("Unable to determine version using [" + CONNECTOR_USER_AGENT + "]", (Throwable)e);
        }
        finally {
            ConnectorIOUtils.closeQuietly((Object)is);
        }
    }
}

