/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.ObjectWithJsonToString;

public class ConnectionOptionsDTO
extends ObjectWithJsonToString {
    private Boolean suppressContentLengthHeader = null;
    private Integer contentLengthHeaderOverride = null;
    private Boolean suppressConnectionHeader = null;
    private Boolean keepAliveOverride = null;
    private Boolean closeSocket = null;

    public ConnectionOptionsDTO(ConnectionOptions connectionOptions) {
        if (connectionOptions != null) {
            this.suppressContentLengthHeader = connectionOptions.getSuppressContentLengthHeader();
            this.contentLengthHeaderOverride = connectionOptions.getContentLengthHeaderOverride();
            this.suppressConnectionHeader = connectionOptions.getSuppressConnectionHeader();
            this.keepAliveOverride = connectionOptions.getKeepAliveOverride();
            this.closeSocket = connectionOptions.getCloseSocket();
        }
    }

    public ConnectionOptionsDTO() {
    }

    public ConnectionOptions buildObject() {
        return new ConnectionOptions().withSuppressContentLengthHeader(this.suppressContentLengthHeader).withContentLengthHeaderOverride(this.contentLengthHeaderOverride).withSuppressConnectionHeader(this.suppressConnectionHeader).withKeepAliveOverride(this.keepAliveOverride).withCloseSocket(this.closeSocket);
    }

    public Boolean getSuppressContentLengthHeader() {
        return this.suppressContentLengthHeader;
    }

    public ConnectionOptionsDTO setSuppressContentLengthHeader(Boolean suppressContentLengthHeader) {
        this.suppressContentLengthHeader = suppressContentLengthHeader;
        return this;
    }

    public Integer getContentLengthHeaderOverride() {
        return this.contentLengthHeaderOverride;
    }

    public ConnectionOptionsDTO setContentLengthHeaderOverride(Integer contentLengthHeaderOverride) {
        this.contentLengthHeaderOverride = contentLengthHeaderOverride;
        return this;
    }

    public Boolean getSuppressConnectionHeader() {
        return this.suppressConnectionHeader;
    }

    public ConnectionOptionsDTO setSuppressConnectionHeader(Boolean suppressConnectionHeader) {
        this.suppressConnectionHeader = suppressConnectionHeader;
        return this;
    }

    public Boolean getKeepAliveOverride() {
        return this.keepAliveOverride;
    }

    public ConnectionOptionsDTO setKeepAliveOverride(Boolean keepAliveOverride) {
        this.keepAliveOverride = keepAliveOverride;
        return this;
    }

    public Boolean getCloseSocket() {
        return this.closeSocket;
    }

    public ConnectionOptionsDTO setCloseSocket(Boolean closeSocket) {
        this.closeSocket = closeSocket;
        return this;
    }
}

