/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink;

import java.util.Properties;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;
import be.fgov.ehealth.technicalconnector.tests.utils.TestPropertiesLoader;


/**
 * tests the default implementation for a General Practitioner.
 * 
 * @author EHP
 * 
 */
public abstract class AbstractDefaultImplementationPersphysician {

    private static final Logger LOG = LoggerFactory.getLogger(AbstractDefaultImplementationPersphysician.class);

    protected static Properties props;

    protected static final String GPCONSULTATION = "gpconsultation";

    protected static final String PROP_TEST_PATIENT_NISS = "test.therlink.referral.doctor.niss";

    @BeforeClass
    public static void init() throws Exception {
        props = TestPropertiesLoader.getProperties("/be.ehealth.businessconnector.therlink.test.properties");
        SessionInitializer.init("/be.ehealth.businessconnector.therlink.test.properties");

    }


    @AfterClass
    public static void unloadSession() {
        LOG.debug("AbstractTherlinkTestWithSession.unloadSession:");
        Session.getInstance().unloadSession();
    }


}