/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.testsupport.junit.rules;

import be.fgov.ehealth.testsupport.junit.rules.SSLVerificationDisabled;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLVerificationTrustStore
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(SSLVerificationDisabled.class);
    private static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    private static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private Map<String, String> properties = new HashMap<String, String>();

    protected void before() throws Throwable {
        String location = this.getTrustStoreLocation("/sslverification-truststore.jks");
        this.setProperty(JAVAX_NET_SSL_TRUST_STORE, location);
        this.setProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD, "changeit");
        this.verifyTrustStore();
    }

    private void setProperty(String key, String value) {
        String curVal = System.getProperty(key);
        if (curVal != null) {
            this.properties.put(key, System.getProperty(key));
        }
        System.setProperty(key, value);
    }

    protected void after() {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            System.clearProperty(entry.getKey());
            if (entry.getValue() == null) continue;
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTrustStore() throws Exception {
        String trustStoreFilePath = System.getProperty(JAVAX_NET_SSL_TRUST_STORE);
        InputStream is = null;
        try {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            char[] passwordCharArray = new char[]{};
            String password = System.getProperty(JAVAX_NET_SSL_TRUST_STORE_PASSWORD);
            if (password != null) {
                passwordCharArray = password.toCharArray();
            }
            is = SSLVerificationTrustStore.class.getResourceAsStream(trustStoreFilePath);
            trustStore.load(is, passwordCharArray);
            ArrayList<String> aliases = Collections.list(trustStore.aliases());
            LOG.debug("Content of truststore at location: " + trustStoreFilePath);
            for (String alias : aliases) {
                Certificate cert = trustStore.getCertificate(alias);
                X509Certificate x509Cert = (X509Certificate)cert;
                String dn = x509Cert.getSubjectX500Principal().getName("RFC2253");
                LOG.debug("\t." + alias + " :" + dn);
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(is);
            throw throwable;
        }
        this.closeQuietly(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTrustStoreLocation(String trustStoreLocation) throws Exception {
        String string;
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = SSLVerificationTrustStore.class.getResourceAsStream(trustStoreLocation);
            LOG.debug("SSLVerificationTrustStore.getTrustStoreLocation: loading file on location [" + trustStoreLocation + "]");
            if (is == null) {
                throw new IllegalArgumentException("trustStore file doesn't exist or is not a file on location [" + trustStoreLocation + "] and resourceFilePath [" + trustStoreLocation + "]");
            }
            LOG.debug("Creating new temp trustStore");
            File tempTrust = File.createTempFile(JAVAX_NET_SSL_TRUST_STORE, ".jks");
            tempTrust.deleteOnExit();
            LOG.debug("Creating new temp trustStore on path [" + tempTrust.getPath() + "] with filename [" + tempTrust.getName() + "]");
            fos = new FileOutputStream(tempTrust);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            string = tempTrust.getPath();
        }
        catch (Throwable throwable) {
            this.closeQuietly(is, fos);
            throw throwable;
        }
        this.closeQuietly(is, fos);
        return string;
    }

    private void closeQuietly(Closeable ... streams) {
        for (Closeable is : streams) {
            if (is == null) continue;
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

