/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.testsupport.junit.rules;

import be.fgov.ehealth.testsupport.junit.annotations.Repeat;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement statement, Description description) {
        Statement result = statement;
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            int times = repeat.value();
            result = new RepeatStatement(statement, times);
        }
        return result;
    }

    private static class RepeatStatement
    extends Statement {
        private final Statement statement;
        private final int repeat;

        public RepeatStatement(Statement statement, int repeat) {
            this.statement = statement;
            this.repeat = repeat;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.repeat; ++i) {
                this.statement.evaluate();
            }
        }
    }
}

