﻿/*
 * Copyright (c) eHealth
 */

using System;
using be.ehealth.technicalconnector.idgenerator;
using be.fgov.ehealth.commons.core.v2;
using be.fgov.ehealth.consultrn.ssinhistory.protocol.v1;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using java.lang;
using org.joda.time;
using org.slf4j;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

/**
 * Integration tests for tarification.
 * 
 * @author eHealth Platform
 * 
 */
namespace be.ehealth.businessconnector.ssinhistory.session
{
	public class SsinHistoryIntegrationTest {
		
		private static Properties props;

		private static SsinHistorySessionService service;

		[SetUpAttribute]
		public static void setupsession() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.ssinhistory.test.properties",true, SupportedLanguages.NET.getAbbreviation());
			props = TestPropertiesLoader.getProperties(".\\be.ehealth.businessconnector.ssinhistory.test.properties");
			service = SsinHistorySessionServiceFactory.getSsinHistorySessionService();
		}

		[TearDownAttribute]
		public static void teardownSession() {
			Session.getInstance().unloadSession();
		}

		[Test]
			public void consultRelatedSsinsValidTest() {
			ConsultRelatedSsinsResponse response = consultRelatedSsins(props.getProperty("test.valid.ssin"));
			checkSuccessRelatedSsins(response);
		}

		[Test]
			public void consultCurrentSsinValidTest() {
			ConsultCurrentSsinResponse response = consultCurrentSsin(props.getProperty("test.valid.ssin"));
			checkSuccessCurrentSsin(response);
		}

		[Test]
			public void consultRelatedSsinsCancelledTest() {
			ConsultRelatedSsinsResponse response = consultRelatedSsins(props.getProperty("test.cancelled.ssin"));
			checkSuccessRelatedSsins(response);
		}

		[Test]
			public void consultCurrentSsinCancelledTest() {
			ConsultCurrentSsinResponse response = consultCurrentSsin(props.getProperty("test.cancelled.ssin"));
			checkSuccessCurrentSsin(response);
		}

		[Test]
			public void consultRelatedSsinsReplacedTest() {
			ConsultRelatedSsinsResponse response = consultRelatedSsins(props.getProperty("test.replaced.ssin"));
			checkSuccessRelatedSsins(response);
		}

		[Test]
			public void consultCurrentSsinReplacedTest() {
			ConsultCurrentSsinResponse response = consultCurrentSsin(props.getProperty("test.replaced.ssin"));
			checkSuccessCurrentSsin(response);
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultRelatedSsinsNotExistTest() {
			consultRelatedSsins(props.getProperty("test.notexist.ssin"));
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultCurrentSsinNotExistTest() {
			consultCurrentSsin(props.getProperty("test.notexist.ssin"));
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultRelatedSsinsIncorrectCheckDigitTest() {
			consultRelatedSsins("12345678912");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultCurrentSsinIncorrectCheckDigitTest() {
			consultCurrentSsin("12345678912");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultRelatedSsinsIncorrectLengthTest() {
			consultRelatedSsins("123");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultCurrentSsinIncorrectLengthTest() {
			consultCurrentSsin("123");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultRelatedSsinsSsinContainsCharTest() {
			consultRelatedSsins("abc");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultCurrentSsinSsinContainsCharTest() {
			consultCurrentSsin("abc");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultRelatedSsinsSsinEmptySsinTest() {
			consultRelatedSsins("");
		}

		[Test]
		[ExpectedException("be.ehealth.technicalconnector.exception.SoaErrorException")]
			public void consultCurrentSsinSsinEmptySsinTest() {
			consultCurrentSsin("");
		}


		private ConsultRelatedSsinsResponse consultRelatedSsins(string ssin) {
			ConsultRelatedSsinsRequest request = new ConsultRelatedSsinsRequest();
			request.setId("_1");
			Calendar calendar = new GregorianCalendar();
			request.setIssueInstant(new org.joda.time.DateTime(calendar.getTimeInMillis()));
			request.setSsin(ssin);

			return service.consultRelatedSsins(request);
		}

		private void checkSuccessRelatedSsins(ConsultRelatedSsinsResponse response) {
			Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The result is not a succes");
			Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The result is not a succes");
			Assert.IsTrue(response.getRelatedSsins().getRelatedSsins().size() > 0, "No related ssins in response");
		}

		private ConsultCurrentSsinResponse consultCurrentSsin(string ssin) {
			ConsultCurrentSsinRequest request = new ConsultCurrentSsinRequest();
			request.setId("_1");
			Calendar calendar = new GregorianCalendar();
			request.setIssueInstant(new org.joda.time.DateTime(calendar.getTimeInMillis()));
			request.setSsin(ssin);

			return service.consultCurrentSsinResponse(request);
		}

		private void checkSuccessCurrentSsin(ConsultCurrentSsinResponse response) {
			Assert.AreEqual("urn:be:fgov:ehealth:2.0:status:Success", response.getStatus().getStatusCode().getValue(), "The result is not a succes");
			Assert.IsNull(response.getStatus().getStatusCode().getStatusCode(), "The result is not a succes");
			Assert.IsNotNull(response.getSsin().getValue(),"No ssin in response");
		}
	}
}