/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.genins.session;

import org.junit.AfterClass;
import org.junit.BeforeClass;

import be.ehealth.businessconnector.genins.test.AbstractGenInsIntegrationTest;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityAsXmlOrFlatRequestType;
import be.fgov.ehealth.genericinsurability.protocol.v1.GetInsurabilityResponse;
import be.fgov.ehealth.technicalconnector.tests.session.SessionDestroyer;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;

/**
 * 
 * GenInsSessionIntegrationTest class.
 * 
 * @author EHP
 * 
 * 
 * 
 */
public class GenInsSessionIntegrationTest extends AbstractGenInsIntegrationTest {

    @BeforeClass
    public static void initConfig() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.genins.test.properties", true);        
    }

    @AfterClass
    public static void tearDown() throws Exception {
        SessionDestroyer.destroy();
    }
  
  
    @Override
    protected GetInsurabilityResponse invoke(GetInsurabilityAsXmlOrFlatRequestType request) throws Exception {
        return GenInsSessionServiceFactory.getGenInsService().getInsurability(request);
    }


}
