﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using java.io;
using java.util;
using org.joda.time;
using org.joda.time.format;
using be.fgov.ehealth.technicalconnector.tests.utils;
using be.ehealth.technicalconnector.config;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;
using be.fgov.ehealth.standards.kmehr.dt.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.business.common.domain;
using be.ehealth.technicalconnector.adapter;
using be.cin.encrypted;
using be.fgov.ehealth.messageservices.core.v1;
using be.ehealth.businessconnector.mycarenet.attestv2.domain;
using be.fgov.ehealth.mycarenet.attest.protocol.v2;
using be.ehealth.businessconnector.attestv2.helper;

namespace be.ehealth.businessconnector.attestv2.session
{
	/**
	 * eAttest Integration Test. The scenarios numbering matches one specified by mycarenet.
	 *
	 * @author EHP
	 */
	[TestFixture]
	public class SendAttestPhysicianIntegrationTest {

		private static HashMap nissProvider = new HashMap();

		private static HashMap nissMatchScenario = new HashMap();
		
		private  AttestIntegrationTestHelper helper = new AttestIntegrationTestHelper();
		

		static object[] testCase =
		{
			// OA 100
			new Object[]{"MED1a", "71010639352", "100", "MED"},
			new Object[]{"MED1b", "71010639352", "100", "MED"},
			new Object[]{"MED2", "85020205931", "100", "MED"},
			new Object[]{"MED3", "85020205931", "100", "MED"},
			new Object[]{"MED4", "71010639352", "100", "MED"},
			new Object[]{"MEDFullOA100", "29041433972", "100", "MED"},

			// OA 500

			new Object[]{"MED1a", "62110906574", "500", "MED"},
			new Object[]{"MED1b", "62110906574", "500", "MED"},
			new Object[]{"MED2", "46111636603", "500", "MED"},
			new Object[]{"MED3", "46111636603", "500", "MED"},
			new Object[]{"MED4", "62110906574", "500", "MED"},
			new Object[]{"MEDFullOA500", "58031245635", "500", "MED"}
		};

		[SetUp]
		public static  void setupsession() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.attestv2.physician.test.properties", SupportedLanguages.NET.getAbbreviation());
		}

		[TearDown]
		public static void teardownSession()  {
			Session.getInstance().unloadSession();
		}


		[Test, TestCaseSource("testCase")]
		public void sendAttestationTest(String scenarioName, String ssin, String oa, String profession) {
			InputReference inputReference = new InputReference();
			SendAttestationResponse response = helper.sendAttestation(inputReference, scenarioName, ssin, profession);

			SignedEncryptedBuilderResponse builderResponse = helper.getBuildSendAttestResponse(response);
			assertResult(inputReference, builderResponse, profession, oa, scenarioName);
		}
		
		private void assertResult(InputReference inputReference, SignedEncryptedBuilderResponse builderResponse, String profession, String oa, String scenarioName)  {
			
			Assert.AreEqual(0, builderResponse.getSignatureVerificationResult().getErrors().size(), "SignatureVerificationResult should contain no error");
			
			XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(builderResponse.getSignedData(), typeof(EncryptedKnownContent)), builderResponse.getRawDecryptedBlob());
			XmlAsserter.assertSimilar(ConnectorXmlUtils.toObject(builderResponse.getRawDecryptedBlob().getBusinessContent().getValue(),typeof(SendTransactionResponse)), builderResponse.getSendTransactionResponse());
			Assert.NotNull(builderResponse.getXades(),"Missing xades");
			Assert.True(Arrays.equals(builderResponse.getRawDecryptedBlob().getXades(),builderResponse.getXades()),"Xades different in blob and exposed xades");
			String expectedResponse = helper.buildExpectedSendAttestResponse(builderResponse, inputReference.getInputReference(), profession, oa, scenarioName);
			XmlAsserter.assertSimilar(expectedResponse, ConnectorXmlUtils.toString(builderResponse.getSendTransactionResponse()));
		}
	}
}
