﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.business.mycarenetdomaincommons.builders;
using be.ehealth.business.mycarenetdomaincommons.util;
using be.ehealth.businessconnector.genericasync.builders;
using be.ehealth.businessconnector.genericasync.mappers;
using be.ehealth.technicalconnector.config.util;
using be.ehealth.technicalconnector.config.util.domain;
using be.ehealth.technicalconnector.handler.domain;
using be.ehealth.technicalconnector.idgenerator;
using be.ehealth.technicalconnector.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;
using java.io;
using java.util;
using java.net;
using NUnit.Framework;
using be.cin.mycarenet.esb.common.v2;
using be.cin.nip.async.generic;
using be.fgov.ehealth.mycarenet.commons.core.v2;
using be.ehealth.businessconnector.genericasync.session;
using org.slf4j;
using be.ehealth.business.mycarenetcommons.builders.util;
using be.ehealth.business.mycarenetcommons.mapper;
using be.ehealth.business.mycarenetdomaincommons.domain;
using be.ehealth.business.mycarenetdomaincommons.mapper;
using be.ehealth.business.mycarenetdomaincommons.domain.async;
using be.ehealth.businessconnector.genericasync.domain;

namespace be.ehealth.businessconnector.mediprima.session
{
	
	/**
     * <p>Runs the post requests for the integration test scenarios specified by MyCareNet. You can of course add your own test files.</p>
     *    
     * <p>For the scenarios 7 to 10 requests to be valid the following editing must be done to the supplied 920000 test files before performing a post operation.
     * The structure of the 920000 message can be found in http://www.inami.fgov.be/SiteCollectionDocuments/instructions_facturation_electronique.pdf  </p>
     * The templating engine is used to edit the template test files located in test resources folder <code>/invoicing/request/"</code>
     * </p>
     *     
    
     * <ul>
     *  <li>Change the <code>nihii</code> with the n° of your choice. It will be set by the templating engine in:</li>
     *  <ul>
     *            <li>record 10 + 20 + 25 + 80 + 90, zone 14 every time</li>
     *            <li>record 50 et 51, zone 15</li>
     *  </ul>   
     *  <ul>
     *   <li>increment <code>sendingNumber</code>: It will be set in record 10, zone 7 (start with 001, 002, 003, and so on)</li>
     *   <li>The date of the day is set in the <code>invoiceDate</code>, record 10, zone 25-26 and also in record 51 zone 55</li>
     *  </ul>
     *
     * <ul>
     *  <li>Perform a tariff consultation as defined in the scenario.</li>
     * </ul> 
     *  From the response of this tariff consultation:
     * <ul>
     *  <li>Retrieve the agreement number (see the financialcontract item) and set it in <code>agreementNumber</code>: the value will be set in record 51, zone 42-45.</li>
     *  <li>Retrieve the encounter date and set it in <code>agreementNumber</code>: the value will be set in record 50, zone 5 and also 6a-6b.</li>
     *  <li>Put the month of the encounter date in in <code>yearMonthEncounterDate</code>:  the value will be set record 10, zone 23.</li>
     * </ul>
     * 
     * @author EHP
     */
	[TestFixture]
	public class MediprimaPostInvoicingGenericAsyncIntegrationTest
	{
		private static Logger LOG = LoggerFactory.getLogger(typeof(MediprimaPostInvoicingGenericAsyncIntegrationTest));

		private static string PROJECT_NAME = "mediprima.invoicing";


		[SetUp]
	    public static void init() {
	    	SessionInitializer.init(".\\be.ehealth.businessconnector.mediprima.test.properties",SupportedLanguages.NET.getAbbreviation());
		}

	    [TearDown]
	    public static void tearDown() {
	        Session.getInstance().unloadSession();
	    }

	    static object[] testCase = {
	    
	        // Business errors
	      new Object[]{"TFAD6Sc01", null, null, null, null, null, null, null},
          new Object[]{"TFAD6Sc02", null, null, null, null, null, null, null},
          new Object[]{"TFAD6Sc03", null, null, null, null, null, null, null},
          new Object[]{"TFAD6Sc04", null, null, null, null, null, null, null},
          new Object[]{"TFAD6Sc05", null, null, null, null, null, null, null},
          new Object[]{"TFAD6Sc06", null, null, null, null, null, null, null},
          
          // Happy flow
          new Object[]{"TFAD6Sc07", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"},
          new Object[]{"TFAD6Sc08", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"},
          new Object[]{"TFAD6Sc09", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"},
          new Object[]{"TFAD6Sc10", "Your sendingNumber", "Your nihii", "Your encounterDate", "Your agreementNumber", "Your yearMonthEncounterDate", "record 10 check digits", "record 90 check digits"}
        };

	    [Test, TestCaseSource("testCase")]
        public void performPostRequestTest(string filename, string sendingNumber, string nihii, string encounterDate,
                                           string agreementNumber, string yearMonthEncounterDate, string r10CheckDigits,
                                           string r90CheckDigits) {
            string invoice = generateFileContentFromFileTemplate(filename, sendingNumber, nihii, encounterDate,
                                           agreementNumber, yearMonthEncounterDate, r10CheckDigits, r90CheckDigits);

            performPost(System.Text.Encoding.UTF8.GetBytes(invoice), PROJECT_NAME, "ECM-HCPFAC");
        }


        private static String generateFileContentFromFileTemplate(string filename, string sendingNumber, string nihii, string encounterDate,
                                           string agreementNumber, string yearMonthEncounterDate, string r10CheckDigits, string r90CheckDigits) {
            Map velocityContext = new HashMap();

            velocityContext.put("sendingNumber", sendingNumber);
            velocityContext.put("nihii", nihii);
            velocityContext.put("invoiceDate", org.joda.time.format.DateTimeFormat.forPattern("yyyyMMdd").print(new org.joda.time.DateTime()));;
            velocityContext.put("encounterDate", encounterDate);
            velocityContext.put("agreementNumber", agreementNumber);
            velocityContext.put("yearMonthEncounterDate", yearMonthEncounterDate);
            velocityContext.put("r10CheckDigits", r10CheckDigits);
            velocityContext.put("r90CheckDigits", r90CheckDigits);

            return TemplateEngineUtils.generate(velocityContext, ".\\invoicing.\\request.\\" + filename);
        }

        private static void performPost(byte[] contentBytes, string serviceName, string messageName) {
            Post postRequest = buildPostRequest(contentBytes, messageName);

            PostResponse responsePost = post(serviceName, postRequest);

            validateResponse(responsePost);
        }

        private static void validateResponse(PostResponse responsePost) {
            ConnectorXmlUtils.dump(responsePost);
            ResponseObjectBuilder responseBuilder = BuilderFactory.getResponseObjectBuilder();
            responseBuilder.handlePostResponse(responsePost);
        }

        private static PostResponse post(string serviceName, Post post) {
            GenAsyncService service = GenAsyncSessionServiceFactory.getGenAsyncService(serviceName);
            WsAddressingHeader header = WsAddressingUtil.createHeader(null, GenericAsyncConstants.POST_SOAP_ACTION);
            return service.postRequest(post, header);
        }

        private static Post buildPostRequest(byte[] contentBytes, string messageName) {
            BlobBuilder blobBuilder = BlobBuilderFactory.getBlobBuilder(PROJECT_NAME);
            Blob blob = blobBuilder.build(contentBytes);
            blob.setMessageName(messageName);
            string commonInputReference = IdGeneratorFactory.getIdGenerator().generateId();
            byte[] xades = BlobUtil.generateXades(blob, PROJECT_NAME);
            
            PostContent postContent = PostContent.Builder()
                .blob(blob)
                .commonInputReference(commonInputReference)
                .isTest(false)
                .messageName(messageName)
                .xades(xades)
                .build();
            
            return BuilderFactory.getRequestObjectBuilder(PROJECT_NAME).buildPostRequest(PROJECT_NAME, postContent);
        }
	}
}
