/*
 * Copyright (c) eHealth
 */

using System;
using be.fgov.ehealth.aa.complextype.v1;
using ikvm.extensions;
using NUnit.Framework;
using java.math;
using be.fgov.ehealth.addressbook.core.v1;
using be.fgov.ehealth.addressbook.protocol.v1;
using org.joda.time;

namespace be.ehealth.businessconnector.addressbook.integration{

/**
 * @author EH054
 *
 */
public class AddressbookTestUtils {

    static String ORG_NIHII = "71089914";

    static String ORG_TYPE = "HOSPITAL";

    static String ORG_NAME = "Hospital wilmar 1";

    static String PROF_NIHII = "13378872004";

    static String PROF_FIRSTNAME = "GEERT KAMIEL";
static String PROF_LASTNAME = "GOETHALS";

    public static GetOrganizationContactInfoRequest createGetOrganizationContactInfoRequest() {
        GetOrganizationContactInfoRequest request = new GetOrganizationContactInfoRequest();
        request.setNIHII(ORG_NIHII);
        request.setIssueInstant(new org.joda.time.DateTime());
        return request;
    }

    public static GetProfessionalContactInfoRequest createGetProfessionalContactInfo() {
        GetProfessionalContactInfoRequest request = new GetProfessionalContactInfoRequest();
        request.setNIHII(PROF_NIHII);
        request.setIssueInstant(new org.joda.time.DateTime());
        return request;
    }

    public static SearchOrganizationsRequest createSearchOrganizationsRequest() {
        SearchOrganizationsRequest request = new SearchOrganizationsRequest();
        request.setNIHII(ORG_NIHII);
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setOffset(1);
        request.setMaxElements(10);
        return request;
    }

    public static SearchProfessionalsRequest createSearchProfessionalsRequest() {
        SearchProfessionalsRequest request = new SearchProfessionalsRequest();
        request.setNIHII(PROF_NIHII);
        request.setIssueInstant(new org.joda.time.DateTime());
        request.setOffset(1);
        request.setMaxElements(10);
        return request;
    }

    public static void verifyResponseGetOrganizationContactInfo(GetOrganizationContactInfoResponse response) {
        OrganizationContactInformationType informations = response.getOrganizationContactInformation();

        Assert.AreEqual(ORG_NIHII, informations.getId().getValue());

        Assert.IsNotNull(informations.getNames());
        Assert.AreNotEqual(0, informations.getNames().size());
        NameType name = (NameType)informations.getNames().get(0);
        Assert.AreEqual(ORG_NAME, name.getValue());

        Assert.IsNotNull(informations.getOrganizationTypeCodes());
        Assert.AreNotEqual(0, informations.getOrganizationTypeCodes().size());
        TypeCodeType typeCodeType = (TypeCodeType) informations.getOrganizationTypeCodes().get(0);
        string value = typeCodeType.getValue();
        Assert.AreEqual(ORG_TYPE, value);
    }

    public static void verifyResponseGetProfessionalContactInfo(GetProfessionalContactInfoResponse response) {
        Assert.IsNotNull(response);
        IndividualContactInformationType informations = response.getIndividualContactInformation();
        Assert.IsNotNull(informations);
        Assert.AreEqual(PROF_FIRSTNAME, informations.getFirstName());
        Assert.AreEqual(PROF_LASTNAME, informations.getLastName());
        
        Assert.AreNotEqual(0, informations.getProfessionalInformations().size());
    }

    public static void verifySearchOrganizationsResponse(SearchOrganizationsResponse response) {
        java.util.List organizations = response.getHealthCareOrganizations();

        Assert.IsNotNull(organizations);
        Assert.AreNotEqual(0, organizations.size());

        be.fgov.ehealth.addressbook.protocol.v1.HealthCareOrganization informations = (be.fgov.ehealth.addressbook.protocol.v1.HealthCareOrganization) organizations.get(0);

        Assert.AreEqual(ORG_NIHII, informations.getId().getValue());

        Assert.IsNotNull(informations.getNames());
        Assert.AreNotEqual(0, informations.getNames().size());
        
        NameType name = (NameType)informations.getNames().get(0);
        Assert.AreEqual(ORG_NAME, name.getValue());

        Assert.IsNotNull(informations.getOrganizationTypeCodes());
        TypeCodeType type = (TypeCodeType) informations.getOrganizationTypeCodes().get(0);
        Assert.AreEqual(ORG_TYPE, type.getValue());
    }

    public static void verifySearchProfessionalsResponse(SearchProfessionalsResponse response) {
        java.util.List professionals = response.getHealthCareProfessionals();

        Assert.IsNotNull(professionals);
        Assert.AreNotEqual(0, professionals.size());

        be.fgov.ehealth.aa.complextype.v1.HealthCareProfessional informations = (be.fgov.ehealth.aa.complextype.v1.HealthCareProfessional) professionals.get(0);

        Assert.AreEqual(PROF_FIRSTNAME, informations.getFirstName());
        Assert.AreEqual(PROF_LASTNAME, informations.getLastName());
        Assert.AreNotEqual(0, informations.getProfessions().size());
    }
}
}