/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.mappers;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.BeforeClass;
import org.junit.Test;

import be.ehealth.business.common.domain.Patient;
import be.ehealth.business.common.util.EidUtils;
import be.fgov.ehealth.technicalconnector.tests.utils.AssumeTools;


/**
 * @author Priscilla Colleaux
 */
public class PatientMapperUserIntegrationTest {

    @BeforeClass
    public static void checkEidPresent() {
        AssumeTools.isEIDEnabled();
    }


    @Test
    public void mapPatient() throws Exception {
        be.ehealth.business.common.domain.Patient patientFromEidCard = EidUtils.readFromEidCard();
        Patient patientMapped = PatientMapper.mapPatient(patientFromEidCard);

        assertNotNull(patientMapped.getEidCardNumber());
        assertNotNull(patientMapped.getLastName());
        assertNotNull(patientMapped.getFirstName());
        assertNotNull(patientMapped.getInss());
        assertEquals(patientFromEidCard.getEidCardNumber(), patientMapped.getEidCardNumber());
        assertEquals(patientFromEidCard.getFirstName(), patientMapped.getFirstName());
        assertEquals(patientFromEidCard.getInss(), patientMapped.getInss());
        assertEquals(patientFromEidCard.getLastName(), patientMapped.getLastName());
    }

}
