/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.dbsupport;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import org.unitils.core.UnitilsException;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.thirdparty.org.apache.commons.dbutils.DbUtils;

public class HsqldbDbSupport
extends DbSupport {
    public HsqldbDbSupport() {
        super("hsqldb");
    }

    @Override
    public Set<String> getTableNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_TYPE = 'TABLE' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_COLUMNS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getViewNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TABLE_NAME from INFORMATION_SCHEMA.SYSTEM_TABLES where TABLE_TYPE = 'VIEW' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getSequenceNames() {
        return this.getSQLHandler().getItemsAsStringSet("select SEQUENCE_NAME from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "'");
    }

    @Override
    public Set<String> getTriggerNames() {
        return this.getSQLHandler().getItemsAsStringSet("select TRIGGER_NAME from INFORMATION_SCHEMA.SYSTEM_TRIGGERS where TRIGGER_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public void disableReferentialConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS where CONSTRAINT_TYPE = 'FOREIGN KEY' AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while disabling not referential constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public void disableValueConstraints() {
        this.disableCheckAndUniqueConstraints();
        this.disableNotNullConstraints();
    }

    protected void disableCheckAndUniqueConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select TABLE_NAME, CONSTRAINT_NAME from INFORMATION_SCHEMA.SYSTEM_TABLE_CONSTRAINTS where CONSTRAINT_TYPE IN ('CHECK', 'UNIQUE') AND CONSTRAINT_SCHEMA = '" + this.getSchemaName() + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String constraintName = resultSet.getString("CONSTRAINT_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while disabling check and unique constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    protected void disableNotNullConstraints() {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getSQLHandler().getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select col.TABLE_NAME, col.COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_COLUMNS col where col.IS_NULLABLE = 'NO' and col.TABLE_SCHEM = '" + this.getSchemaName() + "' " + "AND NOT EXISTS ( select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS pk where pk.TABLE_NAME = col.TABLE_NAME and pk.COLUMN_NAME = col.COLUMN_NAME and pk.TABLE_SCHEM = '" + this.getSchemaName() + "' )");
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                alterStatement.executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(columnName) + " set null");
            }
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Error while disabling not null constraints on schema " + this.getSchemaName(), e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public long getSequenceValue(String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select START_WITH from INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = '" + this.getSchemaName() + "' and SEQUENCE_NAME = '" + sequenceName + "'");
    }

    @Override
    public void incrementSequenceToValue(String sequenceName, long newSequenceValue) {
        this.getSQLHandler().executeUpdate("alter sequence " + this.qualified(sequenceName) + " restart with " + newSequenceValue);
    }

    @Override
    public Set<String> getIdentityColumnNames(String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select COLUMN_NAME from INFORMATION_SCHEMA.SYSTEM_PRIMARYKEYS where TABLE_NAME = '" + tableName + "' AND TABLE_SCHEM = '" + this.getSchemaName() + "'");
    }

    @Override
    public void incrementIdentityColumnToValue(String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().executeUpdate("alter table " + this.qualified(tableName) + " alter column " + this.quoted(identityColumnName) + " RESTART WITH " + identityValue);
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }
}

