/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.ocsp;

import be.fgov.ehealth.etee.crypto.cert.CertPathChecker;
import be.fgov.ehealth.etee.crypto.crl.CRLChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPChecker;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPCheckerResult;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPClient;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPClientFactory;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPData;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPException;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPResponderTrustResult;
import be.fgov.ehealth.etee.crypto.ocsp.OCSPResponderTrustService;
import be.fgov.ehealth.etee.crypto.ocsp.RevocationValues;
import be.fgov.ehealth.etee.crypto.ocsp.RevocationValuesFactory;
import be.fgov.ehealth.etee.crypto.policies.OCSPOption;
import be.fgov.ehealth.etee.crypto.policies.OCSPOptions;
import be.fgov.ehealth.etee.crypto.policies.OCSPPolicy;
import be.fgov.ehealth.etee.crypto.status.CryptoResult;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import be.fgov.ehealth.etee.crypto.status.NotificationFatal;
import be.fgov.ehealth.etee.crypto.status.NotificationWarning;
import be.fgov.ehealth.etee.crypto.utils.Preconditions;
import be.fgov.ehealth.etee.crypto.utils.TimeFrameValidator;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;

class OCSPCheckerImpl
implements OCSPChecker {
    private static final Logger LOGGER = Logger.getLogger(OCSPCheckerImpl.class);
    private OCSPResponderTrustService trustEngine;
    private TimeFrameValidator timeFrameValidator;
    private OCSPPolicy policy;
    private OCSPClient ocspClient;
    private RevocationValuesFactory revocationValuesFactory;

    OCSPCheckerImpl(OCSPPolicy policy, OCSPOptions policyOptions, CRLChecker crlChecker, CertPathChecker certPathChecker) {
        LOGGER.debug((Object)("Initializing OCSPChecker with following options: " + policyOptions));
        this.policy = policy;
        this.revocationValuesFactory = new RevocationValuesFactory();
        this.ocspClient = OCSPClientFactory.getInstance().createOCSPClient(policyOptions);
        KeyStore trustedOscpResponderCaCerts = policyOptions.getKeyStore(OCSPOption.TRUST_STORE);
        this.trustEngine = new OCSPResponderTrustService(trustedOscpResponderCaCerts, crlChecker, certPathChecker);
        Long acceptedClockSkew = policyOptions.getLong(OCSPOption.CLOCK_SKEW);
        this.timeFrameValidator = TimeFrameValidator.create(acceptedClockSkew);
    }

    @Override
    public OCSPPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public CryptoResult<OCSPData> validate(X509Certificate certificate) {
        return this.validate(certificate, new Date(), new RevocationValues());
    }

    @Override
    public CryptoResult<OCSPData> validate(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) {
        OCSPCheckerResult result = null;
        try {
            switch (this.getPolicy()) {
                case NONE: {
                    LOGGER.info((Object)"OCSPCheck disabled. Returning status VALID.");
                    return new OCSPCheckerResult(new OCSPData(be.fgov.ehealth.etee.crypto.cert.CertificateStatus.VALID, null, null));
                }
                case SENDER_OPTIONAL: {
                    return this.validateOptionalOCSP(certificate, signingTime, revocationValues);
                }
                case SENDER_MANDATORY: {
                    return this.validateMandatoryOCSP(certificate, signingTime, revocationValues);
                }
                case RECEIVER_OPTIONAL: {
                    return this.validateOCSP(certificate, signingTime, revocationValues);
                }
                case RECEIVER_MANDATORY: {
                    return this.validateOnlineOCSP(certificate, signingTime, revocationValues);
                }
            }
            LOGGER.error((Object)("Unsupported OCSPPolicy [" + (Object)((Object)this.getPolicy()) + "]. OCSPCheck failed."));
        }
        catch (Exception e) {
            LOGGER.error((Object)"OCSPCheck failed.", (Throwable)e);
            result = new OCSPCheckerResult(NotificationFatal.OCSP_CHECK_FAILED);
        }
        return result;
    }

    private CryptoResult<OCSPData> validateOptionalOCSP(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) throws OCSPException, IOException {
        if (!revocationValues.getOcspVals().isEmpty()) {
            return this.validateEmbeddedOCSP(certificate, signingTime, revocationValues);
        }
        OCSPCheckerResult result = new OCSPCheckerResult(new OCSPData(be.fgov.ehealth.etee.crypto.cert.CertificateStatus.VALID, null, null));
        result.getWarnings().add(NotificationWarning.OCSP_NOT_EMBEDDED);
        return result;
    }

    private CryptoResult<OCSPData> validateMandatoryOCSP(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) throws OCSPException, IOException {
        if (!revocationValues.getOcspVals().isEmpty()) {
            return this.validateEmbeddedOCSP(certificate, signingTime, revocationValues);
        }
        OCSPCheckerResult result = new OCSPCheckerResult(new OCSPData(be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED, null, null));
        result.getErrors().add(NotificationError.OCSP_NOT_EMBEDDED);
        return result;
    }

    private CryptoResult<OCSPData> validateOCSP(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) throws OCSPException, IOException {
        if (!revocationValues.getOcspVals().isEmpty()) {
            return this.validateEmbeddedOCSP(certificate, signingTime, revocationValues);
        }
        return this.validateOnlineOCSP(certificate, signingTime, revocationValues);
    }

    private CryptoResult<OCSPData> validateEmbeddedOCSP(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) throws OCSPException, IOException {
        BasicOCSPResp embeddedOCSPResponse = this.getEmbeddedOCSPResponse(revocationValues, certificate);
        return this.checkEmbeddedOCSP(certificate, signingTime, embeddedOCSPResponse, revocationValues.getCrlVals());
    }

    private CryptoResult<OCSPData> validateOnlineOCSP(X509Certificate certificate, Date signingTime, RevocationValues revocationValues) throws OCSPException, IOException {
        BasicOCSPResp basicResponse = this.ocspClient.sendRequestAndCheckResponse(certificate);
        return this.checkOCSP(certificate, signingTime, basicResponse, revocationValues.getCrlVals());
    }

    BasicOCSPResp getEmbeddedOCSPResponse(RevocationValues revocationValues, X509Certificate cert) throws OCSPException {
        try {
            Iterator<byte[]> i$ = revocationValues.getOcspVals().iterator();
            if (i$.hasNext()) {
                byte[] ocspEncoded = i$.next();
                return this.revocationValuesFactory.decodeOCSPResponse(ocspEncoded);
            }
        }
        catch (IOException e) {
            throw new OCSPException("Embedded OCSPResponse could not be read.", e);
        }
        return null;
    }

    CryptoResult<OCSPData> checkEmbeddedOCSP(X509Certificate certificate, Date signingDate, BasicOCSPResp ocspResponse, List<X509CRL> crls) throws OCSPException, IOException {
        LOGGER.info((Object)("Check embedded OCSP, produced at " + ocspResponse.getProducedAt()));
        CryptoResult<OCSPData> result = this.checkOCSP(certificate, signingDate, ocspResponse, crls);
        if (result.getErrors().contains((Object)NotificationError.OCSP_RESPONDER_CHAIN_EXPIRED) || result.getErrors().contains((Object)NotificationError.OCSP_RESPONDER_CHAIN_REVOKED)) {
            LOGGER.warn((Object)("Embedded ocspResponse is no longer valid: " + result.getErrors() + ". An online OCSP check will be executed."));
            BasicOCSPResp onlineOcsp = this.ocspClient.sendRequestAndCheckResponse(certificate);
            result = this.checkOCSP(certificate, signingDate, onlineOcsp, crls);
        }
        return result;
    }

    CryptoResult<OCSPData> checkOCSP(X509Certificate certificate, Date signingTime, BasicOCSPResp ocspResponse, List<X509CRL> crls) throws OCSPException, IOException {
        Preconditions.checkNotNull(certificate, "OCSP check can only be performed if the certificate is not null");
        Preconditions.checkNotNull(ocspResponse, "OCSP check can only be performed with a valid ocspResponse, this one is null");
        OCSPResponderTrustResult trust = this.trustEngine.verify(certificate, ocspResponse, crls);
        if (trust.hasErrors()) {
            OCSPCheckerResult result;
            if (trust.getFatal() != null) {
                result = new OCSPCheckerResult(trust.getFatal());
            } else {
                result = new OCSPCheckerResult(new OCSPData(be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED, null, (List)trust.getData()));
                result.getErrors().addAll(trust.getErrors());
            }
            return result;
        }
        be.fgov.ehealth.etee.crypto.cert.CertificateStatus certStatus = this.getCertificateStatus(certificate, signingTime, ocspResponse);
        OCSPCheckerResult result = new OCSPCheckerResult(new OCSPData(certStatus, ocspResponse.getEncoded(), (List)trust.getData()));
        if (be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED.equals((Object)certStatus)) {
            result.getErrors().add(NotificationError.OCSP_RESPONSE_INVALID);
        }
        if (trust.hasWarnings()) {
            result.getWarnings().addAll(trust.getWarnings());
        }
        return result;
    }

    private be.fgov.ehealth.etee.crypto.cert.CertificateStatus getCertificateStatus(X509Certificate certificate, Date inSigningTime, BasicOCSPResp basicOcspResp) throws OCSPException {
        SingleResp[] singleResps;
        Date signingTime = inSigningTime;
        if (signingTime != null) {
            if (!this.timeFrameValidator.validate(null, signingTime, basicOcspResp.getProducedAt())) {
                throw new OCSPException("The OCSP response was produced before the SigningTime.");
            }
        } else {
            signingTime = new Date();
        }
        for (SingleResp singleResp : singleResps = basicOcspResp.getResponses()) {
            if (!this.isMatch(singleResp.getCertID(), certificate)) continue;
            return this.validateStatus(certificate, signingTime, singleResp.getCertStatus());
        }
        String errMsg = " the OCSP response does not contain a status of the certificate in question [SerialNumber=" + certificate.getSerialNumber() + "]";
        LOGGER.warn((Object)errMsg);
        return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED;
    }

    private be.fgov.ehealth.etee.crypto.cert.CertificateStatus validateStatus(X509Certificate certificate, Date signingTime, Object status) {
        if (status == CertificateStatus.GOOD) {
            LOGGER.info((Object)("Certificate " + certificate.getSubjectX500Principal() + " is NOT REVOKED."));
            return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.VALID;
        }
        if (status instanceof RevokedStatus) {
            Date revocationTime = ((RevokedStatus)status).getRevocationTime();
            if (signingTime.before(revocationTime)) {
                LOGGER.info((Object)("OCSP revocation time [" + revocationTime + "] after the signing time, the certificate was still valid at " + signingTime));
                return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.VALID;
            }
            LOGGER.warn((Object)("OCSP revocation time [" + revocationTime + "] before the signing time, the certificate was no longer valid at " + signingTime));
            return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.REVOKED;
        }
        if (status instanceof UnknownStatus) {
            String msg = " the revocation status of certificate is UNKNOWN by the OCSP Service.";
            LOGGER.warn((Object)" the revocation status of certificate is UNKNOWN by the OCSP Service.");
            return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED;
        }
        String errMsg = " the OCSP response contains an incorrect revocation status field: " + status;
        LOGGER.warn((Object)errMsg);
        return be.fgov.ehealth.etee.crypto.cert.CertificateStatus.UNSPECIFIED;
    }

    private boolean isMatch(CertificateID certID, X509Certificate certificate) {
        if (certID == null) {
            LOGGER.warn((Object)"CertificateID is null.");
            return false;
        }
        if (certificate == null) {
            LOGGER.warn((Object)"CertificateID is null.");
            return false;
        }
        return certID.getSerialNumber().equals(certificate.getSerialNumber());
    }
}

