/*
 * Copyright (c) eHealth
 */
using System;
using System.IO;
using NUnit.Framework;
using be.ehealth.businessconnector.wsconsent.builders.impl;
using be.fgov.ehealth.hubservices.core.v2;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.fgov.ehealth.technicalconnector.tests.utils;

namespace be.ehealth.businessconnector.wsconsent.builders
{
	[TestFixture]
	public class PatientInfoBuilderIntegrationTest
	{

		[SetUp]
		public static void init() {
			SessionInitializer.init(".\\be.ehealth.businessconnector.wsconsent.test.properties", SupportedLanguages.NET.getAbbreviation());
		}

		[Test]
		public void testPatientInfoBuilder()  {
			PatientIdType patient =  RequestObjectBuilderFactory.getPatientInfoBuilder().readFromEidCard();
			// INSS
			Assert.AreEqual(IDPATIENTschemes.INSS, ((IDPATIENT)patient.getIds().get(0)).getS());
			Assert.IsNotNull(((IDPATIENT)patient.getIds().get(0)).getValue());
			Assert.IsNotNull(patient.getFirstname());
			Assert.IsNotNull(patient.getFamilyname());
			// Eid
			Assert.AreEqual(IDPATIENTschemes.EID_CARDNO, ((IDPATIENT)patient.getIds().get(1)).getS());
			Assert.IsNotNull(((IDPATIENT)patient.getIds().get(1)).getValue());
		}
	}
}
