package be.ehealth.technicalconnector.cache;

import static be.ehealth.technicalconnector.cache.CacheFactory.CacheType.MEMORY;

import org.junit.Assert;
import org.junit.Test;

/**
 * Unit test to verify the behaviour of the {@link CacheFactory}
 *
 * @author EHP
 */
public class CacheFactoryTest {

    private Cache<String, String> cache = CacheFactory.newInstance(MEMORY);

    @Test
    public void notNull() throws Exception {
        Assert.assertNotNull(cache);
    }

    @Test
    public void verify() throws Exception {
        cache.put("entry", "value");
        Assert.assertEquals("value", cache.get("entry"));
        cache.remove("entry");
        Assert.assertNull(cache.get("entry"));
    }

    @Test
    public void clear() throws Exception {
        cache.put("entry", "value");
        Assert.assertEquals("value", cache.get("entry"));
        cache.clear();
        Assert.assertNull(cache.get("entry"));
    }

}