/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.security;

import java.util.List;

import javax.xml.bind.JAXB;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

import be.ehealth.businessconnector.hub.util.RequestTypeBuilder;
import be.fgov.ehealth.hubservices.core.v1.RequestType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;
import be.fgov.ehealth.standards.kmehr.schema.v1.HcpartyType;
import be.fgov.ehealth.technicalconnector.tests.junit.rule.SessionRule;


/**
 * Integration test for {@link HubRequestWithEncryption}
 * 
 * @author EHP
 * 
 */
public class HubRequestWithEncryptionIntegrationTest {

    @Rule
    public SessionRule rule = SessionRule.withActiveSession().forEnvironment("acc").forProfession("persphysician").forUser("hannes").build();



    /**
     * @throws Exception
     */
    @Test
    public void testRequestTypeBuilder() throws Exception {        
        RequestType req = RequestTypeBuilder.init().addAuthorWithEncryptionInformation().build();
        List<HcpartyType> partiesList = req.getAuthor().getHcparties();
        boolean containsEncryption = false;
        for (HcpartyType hcpartyType : partiesList) {
            if (hcpartyType.getFirstname() != null) {
                for (IDHCPARTY hcparty : hcpartyType.getIds()) {
                    if (hcparty.getS().compareTo(IDHCPARTYschemes.ID_ENCRYPTION_ACTOR) == 0) {
                        containsEncryption = true;
                    }
                }
            }
        }
        Assert.assertTrue(containsEncryption);

        JAXB.marshal(req, System.out);
    }
}
