/*
 * Decompiled with CFR 0.152.
 */
package be.ehealth.technicalconnector.handler;

import be.ehealth.technicalconnector.handler.AbstractSOAPHandler;
import be.ehealth.technicalconnector.handler.domain.WsAddressingHeader;
import be.ehealth.technicalconnector.handler.domain.WsAddressingRelatesTo;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsAddressingHandlerV200508
extends AbstractSOAPHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WsAddressingHandlerV200508.class);
    public static final String WS_ADDRESSING_V200508_USE = "be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508.use";
    public static final String MESSAGECONTEXT_WS_ADDRESSING_V200508 = "be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508";
    private static final String NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private static final String WSA_PREFIX = "wsa";
    private static final QName MESSAGEID = new QName("http://www.w3.org/2005/08/addressing", "MessageID", "wsa");
    private static final QName RELATESTO = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo", "wsa");
    private static final QName RELATIONSHIPTYPE = new QName("http://www.w3.org/2005/08/addressing", "RelationshipType", "wsa");
    private static final QName TO = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    private static final QName ACTION = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
    private static final QName FROM = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
    private static final QName REPLYTO = new QName("http://www.w3.org/2005/08/addressing", "ReplyTo", "wsa");
    private static final QName MUST_UNDERSTAND = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "S");
    private static final QName ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address", "wsa");
    private static final QName FAULTTO = new QName("http://www.w3.org/2005/08/addressing", "FaultTo", "wsa");

    @Override
    public boolean handleOutbound(SOAPMessageContext context) {
        Boolean wsAddressingUse;
        Boolean bl = wsAddressingUse = context.get((Object)WS_ADDRESSING_V200508_USE) == null ? Boolean.FALSE : (Boolean)context.get((Object)WS_ADDRESSING_V200508_USE);
        if (wsAddressingUse.booleanValue()) {
            try {
                WsAddressingHeader header = (WsAddressingHeader)context.get((Object)MESSAGECONTEXT_WS_ADDRESSING_V200508);
                if (header == null) {
                    LOG.warn("No WsAddressingHeader in the requestMap. Skipping the WsAddressingHandler.");
                    return true;
                }
                SOAPHeader soapHeader = WsAddressingHandlerV200508.getSOAPHeader(context);
                this.processRequiredElements(header, soapHeader);
                this.processOptionalElements(header, soapHeader);
                context.getMessage().saveChanges();
            }
            catch (SOAPException e) {
                LOG.error("Error while generating WS-Addressing header", (Throwable)e);
            }
        } else {
            LOG.warn("WsAddressingHandler is configured but be.ehealth.technicalconnector.handler.WsAddressingHandlerV200508.useproperty was not present or set to FALSE.");
        }
        return true;
    }

    private void processOptionalElements(WsAddressingHeader header, SOAPHeader soapHeader) throws SOAPException {
        if (header.getTo() != null) {
            soapHeader.addChildElement(TO).setTextContent(header.getTo().toString());
        }
        if (header.getMessageID() != null) {
            soapHeader.addChildElement(MESSAGEID).setTextContent(header.getMessageID().toString());
        }
        for (WsAddressingRelatesTo relateTo : header.getRelatesTo()) {
            this.generateRelateToElement(soapHeader, relateTo);
        }
        if (header.getFrom() != null && !header.getFrom().isEmpty()) {
            soapHeader.addChildElement(FROM).setTextContent(header.getFrom().toString());
        }
        if (header.getReplyTo() != null && !header.getReplyTo().isEmpty()) {
            soapHeader.addChildElement(REPLYTO).addChildElement(ADDRESS).setTextContent(header.getReplyTo().toString());
        }
        if (header.getFaultTo() != null && !header.getFaultTo().isEmpty()) {
            soapHeader.addChildElement(FAULTTO).addChildElement(ADDRESS).setTextContent(header.getFaultTo().toString());
        }
    }

    private void generateRelateToElement(SOAPHeader soapHeader, WsAddressingRelatesTo relateTo) throws SOAPException {
        SOAPElement relateToElement = soapHeader.addChildElement(RELATESTO);
        if (relateTo.getRelationshipType() != null && !relateTo.getRelationshipType().isEmpty()) {
            relateToElement.addAttribute(RELATIONSHIPTYPE, relateTo.getRelationshipType());
        }
        if (relateTo.getRelationshipType() != null) {
            relateToElement.setTextContent(relateTo.getReleatesTo().toString());
        }
    }

    private void processRequiredElements(WsAddressingHeader header, SOAPHeader soapHeader) throws SOAPException {
        SOAPElement actionElement = soapHeader.addChildElement(ACTION);
        actionElement.addAttribute(MUST_UNDERSTAND, header.getMustUnderstand());
        actionElement.setTextContent(header.getAction().toString());
    }

    private static SOAPHeader getSOAPHeader(SOAPMessageContext context) throws SOAPException {
        SOAPHeader soapHeader = context.getMessage().getSOAPHeader();
        if (soapHeader == null) {
            context.getMessage().getSOAPPart().getEnvelope().addHeader();
            soapHeader = context.getMessage().getSOAPHeader();
        }
        return soapHeader;
    }

    @Override
    public boolean handleFault(SOAPMessageContext context) {
        this.handleMessage(context);
        return false;
    }
}

