/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.therlink.mappers;

import java.util.ArrayList;
import java.util.List;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.therlink.domain.HcParty;
import be.ehealth.businessconnector.therlink.exception.TherLinkBusinessConnectorException;
import be.fgov.ehealth.hubservices.core.v2.HCPartyIdType;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTY;
import be.fgov.ehealth.standards.kmehr.id.v1.IDHCPARTYschemes;


/**
 * Tests for {@link }
 * 
 * @author EHP
 */
@SuppressWarnings("deprecation")
public class HcPartyMapperTest {

    private static final Logger LOG = LoggerFactory.getLogger(HcPartyMapperTest.class);

    @Test
    public void mapHcPartyMultipleSameIdTest() throws TherLinkBusinessConnectorException {
        HcParty hcparty = new HcParty();
        hcparty.setFamilyName("Strauven");
        hcparty.setFirstName("Guillaume");
        hcparty.setInss("91121208397");
        hcparty.setNihii("1");
        hcparty.setCbe("2");
        hcparty.setEHP("3");
        hcparty.setApplicationID("1");

        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.INSS);
        id.setSV("1.0");
        id.setValue("91121208397");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        id.setValue("1");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        id.setValue("2");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.ID_HCPARTY);
        id.setSV("1.0");
        id.setValue("3");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("1");
        id.setSL("application_ID");
        hcparty.getIds().add(id);

        HCPartyIdType mappedHcParty = HcPartyMapper.mapHcPartyIdType(hcparty);


        List<IDHCPARTY> ids = mappedHcParty.getIds();
        List<IDHCPARTY> baseCompare = new ArrayList<IDHCPARTY>();
        baseCompare.addAll(ids);
        LOG.debug("Number of ids :" + ids.size());
        int count = 0;
        for (int i = 0; i < ids.size(); i++) {
            count = 0;
            IDHCPARTY id1 = ids.get(i);
            for (int j = 0; j < baseCompare.size(); j++) {
                IDHCPARTY id2 = baseCompare.get(j);
                if (id1.getS().equals(id2.getS()) && id1.getValue().equals(id2.getValue())) {
                    count++;
                }
            }

            if (count > 1) {
                Assert.fail("Should not have the same id twice in the list");
            }
        }
    }

    @Test
    public void mapHcPartySeperateId() throws TherLinkBusinessConnectorException {
        HcParty hcparty = new HcParty();
        hcparty.setFamilyName("Strauven");
        hcparty.setFirstName("Guillaume");
        hcparty.setInss("91121208397");
        hcparty.setApplicationID("1");

        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.INSS);
        id.setSV("1.0");
        id.setValue("91121208397");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("2");
        id.setSL("application_ID");
        hcparty.getIds().add(id);

        HCPartyIdType mappedHcParty = HcPartyMapper.mapHcPartyIdType(hcparty);

        List<IDHCPARTY> ids = mappedHcParty.getIds();
        List<IDHCPARTY> baseCompare = new ArrayList<IDHCPARTY>();
        baseCompare.addAll(ids);

        int count = 0;
        for (int i = 0; i < ids.size(); i++) {
            count = 0;
            IDHCPARTY id1 = ids.get(i);
            for (int j = 0; j < baseCompare.size(); j++) {
                IDHCPARTY id2 = baseCompare.get(j);
                if (id1.getS().equals(id2.getS()) && id1.getValue().equals(id2.getValue())) {
                    count++;
                }
            }

            if (count > 1) {
                Assert.fail("Should not have the same id twice in the list");
            }
        }
    }

    @Test
    public void mapHcParty2AppIdDiff() throws TherLinkBusinessConnectorException {
        HcParty hcparty = new HcParty();
        hcparty.setFamilyName("Strauven");
        hcparty.setFirstName("Guillaume");
        hcparty.setInss("91121208397");
        hcparty.setApplicationID("1");

        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.INSS);
        id.setSV("1.0");
        id.setValue("91121208397");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("1");
        id.setSL("application_ID");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("2");
        id.setSL("application_ID");
        hcparty.getIds().add(id);

        HCPartyIdType mappedHcParty = HcPartyMapper.mapHcPartyIdType(hcparty);

        List<IDHCPARTY> ids = mappedHcParty.getIds();
        List<IDHCPARTY> baseCompare = new ArrayList<IDHCPARTY>();
        baseCompare.addAll(ids);

        int count = 0;
        for (int i = 0; i < ids.size(); i++) {
            count = 0;
            IDHCPARTY id1 = ids.get(i);
            for (int j = 0; j < baseCompare.size(); j++) {
                IDHCPARTY id2 = baseCompare.get(j);
                if (id1.getS().equals(id2.getS()) && id1.getValue().equals(id2.getValue())) {
                    count++;
                }
            }

            if (count > 1) {
                Assert.fail("Should not have the same id twice in the list");
            }
        }
    }

    @Test
    public void mapHcParty2LocalIdDiff() throws TherLinkBusinessConnectorException {
        HcParty hcparty = new HcParty();
        hcparty.setFamilyName("Strauven");
        hcparty.setFirstName("Guillaume");
        hcparty.setInss("91121208397");
        hcparty.setApplicationID("1");

        IDHCPARTY id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.INSS);
        id.setSV("1.0");
        id.setValue("91121208397");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("1");
        id.setSL("application_ID");
        hcparty.getIds().add(id);

        id = new IDHCPARTY();
        id.setS(IDHCPARTYschemes.LOCAL);
        id.setSV("1.0");
        id.setValue("1");
        id.setSL("Another_sl");
        hcparty.getIds().add(id);

        HCPartyIdType mappedHcParty = HcPartyMapper.mapHcPartyIdType(hcparty);

        List<IDHCPARTY> ids = mappedHcParty.getIds();
        List<IDHCPARTY> baseCompare = new ArrayList<IDHCPARTY>();
        baseCompare.addAll(ids);

        int count = 0;
        for (int i = 0; i < ids.size(); i++) {
            count = 0;
            IDHCPARTY id1 = ids.get(i);

            for (int j = 0; j < baseCompare.size(); j++) {
                IDHCPARTY id2 = baseCompare.get(j);
                if (id1.getS().equals(id2.getS()) && id1.getValue().equals(id2.getValue()) && (id1.getSL() != null && id2.getSL() != null && id1.getSL().equals(id2.getSL())) || (id1.getSL() == null && id2.getSL() == null)) {
                    count++;
                }
            }

            if (count > 1) {
                Assert.fail("Should not have the same id twice in the list");
            }
        }
    }

}
