/*
 * Decompiled with CFR 0.152.
 */
package be.fgov.ehealth.etee.crypto.decrypt;

import be.fgov.ehealth.etee.crypto.decrypt.EnvelopedDataDecrypterResult;
import be.fgov.ehealth.etee.crypto.policies.EncryptionPolicy;
import be.fgov.ehealth.etee.crypto.status.NotificationError;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;

final class KeyLengthVerifier {
    private static final int BYTE_SIZE = 8;
    private static final Logger LOGGER = Logger.getLogger(KeyLengthVerifier.class);

    private KeyLengthVerifier() {
    }

    static void verifySecretKeyLength(EncryptionPolicy encryptionPolicy, EnvelopedDataDecrypterResult result, SecretKey key) {
        if (key.getEncoded().length * 8 < encryptionPolicy.getKeksize()) {
            LOGGER.warn((Object)String.format("KEK length is not authorized. Is %d and should be %d", key.getEncoded().length * 8, encryptionPolicy.getKeksize()));
            result.getErrors().add(NotificationError.DECRYPTION_SYMMETRIC_KEY_LENGTH_UNAUTHORIZED);
        } else {
            LOGGER.info((Object)"KEK length of SecretKey is OK.");
        }
    }

    static void verifyPrivateKeyLength(EnvelopedDataDecrypterResult result, PrivateKey key, int keyEncryptionKeyLength) {
        String binaryRepresentation = null;
        if (key instanceof RSAPrivateKey) {
            binaryRepresentation = ((RSAPrivateKey)key).getModulus().toString(2);
        } else if (key instanceof DSAPrivateKey) {
            binaryRepresentation = ((DSAPrivateKey)key).getX().toString(2);
        }
        if (binaryRepresentation != null && binaryRepresentation.length() < keyEncryptionKeyLength) {
            LOGGER.warn((Object)String.format("KEK length is not authorized. Is %d and should be %d", binaryRepresentation.length(), keyEncryptionKeyLength));
            result.getErrors().add(NotificationError.DECRYPTION_ASYMMETRIC_KEY_LENGTH_UNAUTHORIZED);
        } else {
            LOGGER.info((Object)"KEK length of PrivateKey is OK.");
        }
    }
}

