﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using be.fgov.ehealth.standards.kmehr.dt.v1;
using ikvm.extensions;
using java.lang;
using NUnit.Framework;
using java.io;
using java.net;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;
using org.apache.commons.io;
using org.apache.commons.lang3;
using org.joda.time;
using be.ehealth.businessconnector.chapterIV.builders;
using be.fgov.ehealth.standards.kmehr.id.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

/**
 * test utilities.
 * 
 * @author EHP
 * 
 */
namespace be.ehealth.businessconnector.chapterIV.testutil
{
	public class TestUtils
	{

		private static MarshallerHelper helper = new MarshallerHelper(typeof(ConsultChap4MedicalAdvisorAgreementResponse), typeof(ConsultChap4MedicalAdvisorAgreementResponse));

		private TestUtils() {
			throw new UnsupportedOperationException();
		}


		public static ConsultChap4MedicalAdvisorAgreementResponse mapToConsultResponseObject(string fileLocation) {
			InputStream ios = null;
			try {
				ios = ConnectorIOUtils.getResourceAsStream(fileLocation);
				return (ConsultChap4MedicalAdvisorAgreementResponse) helper.toObject(ios);
			} finally {
				IOUtils.closeQuietly(ios);
			}
		}

		public static string getFileContents(string fileLocation) {
			return ConnectorIOUtils.convertStreamToString(ConnectorIOUtils.getResourceAsStream(fileLocation));
		}



		public static void updateTransactionDate(FolderType folder, org.joda.time.DateTime time) {
			if (folder != null) {
				for ( int i=0; i<folder.getTransactions().size();i++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(i);
					transaction.setDate(time);
					transaction.setTime(time);
				}
			}
		}

		public static void updateAuthor(FolderType folder) {
			if (folder != null) {
				for ( int i=0; i<folder.getTransactions().size();i++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(i);
					transaction.setAuthor( KmehrBuilderFactory.getKmehrBuilder().generateAuthor());
				}
			}
		}

		public static void updatePatient(FolderType folder, string inss) {
			if (folder != null) {
				for ( int i=0; i<folder.getPatient().getIds().size();i++) {
					IDPATIENT idPatient = (IDPATIENT)folder.getPatient().getIds().get(i);
					idPatient.setValue(inss);
				}
			}
		}

		public static void updateCNK(FolderType folder, string sv, string value) {
			if (folder != null && StringUtils.isNotBlank(sv) && StringUtils.isNotBlank(value)) {
				for ( int indTransac=0; indTransac<folder.getTransactions().size();indTransac++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(indTransac);
					for (int indItem=0; indItem<transaction.getItem().size();indItem++) {
						ItemType item = (ItemType) transaction.getItem().get(indItem);
						bool found = false;
						for (int indCd=0; indCd<item.getCds().size(); indCd++) {
							CDITEM cd = (CDITEM) item.getCds().get(indCd);
							if (cd.getValue().equalsIgnoreCase("chapter4reference")) {
								found = true;
								break;
							}
						}
						if (found) {
							for (int indContent=0; indContent < item.getContents().size(); indContent++){
								ContentType content = (ContentType) item.getContents().get(indContent);
								for (int indCd=0; indCd<content.getCds().size(); indCd++) {
									CDCONTENT contentCD = (CDCONTENT) content.getCds().get(indCd);
									if (contentCD.getS() == CDCONTENTschemes.CD_DRUG_CNK) {
										contentCD.setSV(sv);
										contentCD.setValue(value);
									}
								}
							}
						}
					}

				}
			}
		}

		public static void updateReference(FolderType folder, string ticket) {
			if (folder != null && StringUtils.isNotBlank(ticket)) {
				for ( int indTransac=0; indTransac<folder.getTransactions().size();indTransac++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(indTransac);
					for (int indItem=0; indItem<transaction.getItem().size();indItem++) {
						ItemType item = (ItemType) transaction.getItem().get(indItem);
						bool found = false;
						for (int indCd=0; indCd<item.getCds().size(); indCd++) {
							CDITEM cd = (CDITEM) item.getCds().get(indCd);
							if (cd.getValue().equalsIgnoreCase("careproviderreference")) {
								found = true;
								break;
							}
						}
						if (found) {
							for (int indContent=0; indContent < item.getContents().size(); indContent++){
								ContentType content = (ContentType) item.getContents().get(indContent);
								for (int indText=0; indText < content.getTexts().size(); indText++){
									TextType text = (TextType) content.getTexts().get(indText);
									text.setValue(ticket);
								}
							}
						}
					}

				}
			}
		}

		public static void updateAgreementDate(FolderType folder, org.joda.time.DateTime time) {
			bool cdAgreementStartDateFound = false;
			
			if (folder != null) {
				for (int indFolder=0;indFolder<folder.getTransactions().size();indFolder++) {
					TransactionType transaction = (TransactionType)folder.getTransactions().get(indFolder);
					for(int indTrans=0; indTrans<transaction.getItem().size(); indTrans++) {
						ItemType item = (ItemType)transaction.getItem().get(indTrans);
						for(int indItem=0; indItem < item.getCds().size(); indItem++) {
							CDITEM cdFromItem = (CDITEM)item.getCds().get(indItem);
							if(cdFromItem.getValue().Equals("agreementstartdate")) {
								cdAgreementStartDateFound = true;
							}
						}
						
						for(int indCont=0;indCont<item.getContents().size();indCont++){
							ContentType content = (ContentType)item.getContents().get(indCont);
							if(cdAgreementStartDateFound){
								content.setDate(time);
								cdAgreementStartDateFound = false;
							}
						}
					}
				}
			}
		}
		
		public static org.joda.time.DateTime extractDate(FolderType folder) {
			if (folder != null) {
				java.util.List items = ((TransactionType)folder.getTransactions().get(0)).getItem();
				for (int indItem=0; indItem < items.size(); indItem++) {
					ItemType itemType = (ItemType) items.get(indItem);
					if (CDITEMMAAvalues.CONSULTATIONSTARTDATE.value().Equals(((CDITEM)itemType.getCds().get(0)).getValue()) && ((CDITEM)itemType.getCds().get(0)).getS() == CDITEMschemes.CD_ITEM_MAA) {
						return ((ContentType)itemType.getContents().get(0)).getDate();
					} else if (CDITEMMAAvalues.AGREEMENTSTARTDATE.value().Equals(((CDITEM)itemType.getCds().get(0)).getValue()) && ((CDITEM)itemType.getCds().get(0)).getS() == CDITEMschemes.CD_ITEM_MAA) {
						return ((ContentType)itemType.getContents().get(0)).getDate();

					}
				}
			}
			return null;
		}
		
		public static string printErrors(java.util.List errors) {
			StringBuffer sb = new StringBuffer();
			for (int i=0; i<errors.size();i++) {
				ErrorType error = (ErrorType) errors.get(i);
				sb.append(printError(error));
			}
			return sb.toString();
		}
		
		public static string printError(ErrorType error) {
			StringBuffer sb = new StringBuffer("errors codes = ");
			for (int i=0; i<error.getCds().size();i++) {
				CDERROR cd =(CDERROR)error.getCds().get(i);
				sb.append(cd.getValue() + " ");
			}
			sb.append("Description : " + error.getDescription() + " ");
			sb.append("url : " + error.getUrl());
			return sb.toString();
		}
	}
}
