﻿/*
 * Copyright (c) eHealth
 */
using System;
using ikvm.extensions;
using NUnit.Framework;
using be.ehealth.businessconnector.ehboxV2.session;
using java.util;
using be.ehealth.businessconnector.ehbox.api.domain;
using be.ehealth.businessconnector.ehbox.api.utils;
using be.ehealth.businessconnector.ehboxV2.builders;
using be.fgov.ehealth.technicalconnector.tests.session;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.ehbox.consultation.protocol.v2;
using be.fgov.ehealth.ehbox.core.v2;
using be.fgov.ehealth.ehbox.publication.protocol.v2;

/**
 * eHealthBox Service Integration Tests This test shows the use of the eHealthBox Service through the use of the Business Connector.
 * 
 * The tests below use the Session Management Service to manage the session and SAML/STS token. The eHealthBox of the test user specified in
 * the business connector property file is used, these tests expect that this is set to a valid INSS of a citizen.
 */
namespace be.ehealth.businessconnector.ehboxV2.session
{
	[TestFixture]
	public class EhboxV2ServicePublicationIntegrationTest : AbstractEhboxV2IntegrationTest
	{
		private static String FILE_AS_DOC = ".\\be.ehealth.businessconnector.ehboxv2.test.properties";

		private static String TEST_SESSION_USER = "82051234978";
		
		[SetUp]
		public void setup()
		{
			
			/*
			 * Create the parameters of the new message
			 */
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
			
			
			NewsMessage news = new NewsMessage();
			news.getDocument().setTitle("News " + new Date());
			news.getDocument().setContent("eureka".getBytes());
			
			news.setDestinations(getDestination());
			news.setImportant(true);
			news.setEncrypted(false);
			
			SendMessageRequest request = builder.buildMessage(news);
			
			
			/*
			 * Invoke the business connector framework's eHealthBox's sendMessage operation
			 */
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			SendMessageResponse response = service.sendMessage(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());
		}
		
		/**
		 * Test the sendMessage operation from the eHealthBox Service through the use of the Business Connector. This test creates and sends a
		 * message to a predefined eHealthBox, based on a person's INSS
		 * 
		 * The following main steps are done: - Create the parameters of the new message - Invoke the business connector - Verify the response
		 * @throws Exception
		 */
		[Test]
		public void testSendNewsEncryptedMessage()
		{
			/*
			 * Create the parameters of the new message
			 */
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
			
			
			NewsMessage news = new NewsMessage();
			news.getDocument().setTitle("News " + new Date());
			news.getDocument().setContent("eureka".getBytes());
			
			news.setDestinations(getDestination());
			news.setImportant(true);
			news.setEncrypted(true);
			
			SendMessageRequest request = builder.buildMessage(news);
			
			CustomMetaType type = new CustomMetaType();
			type.setValue("");
			type.setKey("");
			
			
			/*
			 * Invoke the business connector framework's eHealthBox's sendMessage operation
			 */
			
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			SendMessageResponse response = service.sendMessage(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());
			
			
		}
		
		
		/**
		 * @throws Exception
		 */
		[Test]
		public void testSendEncryptedDocumentWithAnnex() {
			/*
			 * Create the parameters of the new message
			 */
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
			
			DocumentMessage documentMsg = new DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			documentMsg.setEncrypted(true);
			
			documentMsg.setFreeText("Free text:" + UUID.randomUUID());
			documentMsg.setPatientInss(TEST_SESSION_USER);
			
			Document doc = new Document();
			doc.setTitle("Encrypted document " + new Date());
			doc.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			doc.setMimeType("text/plain");
			doc.setFilename("be.ehealth.businessconnector.properties");
			documentMsg.setDocument(doc);
			
			Document annex = new Document();
			annex.setTitle("properties");
			annex.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			annex.setFilename("be.ehealth.technicalconnector.properties");
			annex.setMimeType("text/plain");
			documentMsg.getAnnexList().add(annex);
			
			SendMessageRequest request = builder.buildMessage(documentMsg);
			/*
			 * Invoke the business connector framework's eHealthBox's sendMessage operation
			 */
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			SendMessageResponse response = service.sendMessage(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());
			
			
			
		}

		
		/**
		 * @throws Exception
		 */
		[Test]
		public void testSendDocumentWithAnnex()	    {
			/*
			 * Create the parameters of the new message
			 */
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
			
			DocumentMessage documentMsg = new DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			
			documentMsg.setFreeText("Free text:" + UUID.randomUUID());
			
			
			Document doc = new Document();
			doc.setTitle("Document " + new Date());
			doc.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			doc.setMimeType("text/plain");
			doc.setFilename("be.ehealth.businessconnector.properties");
			documentMsg.setDocument(doc);
			
			Document annex = new Document();
			annex.setTitle("properties");
			annex.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			annex.setFilename("be.ehealth.technicalconnector.properties");
			annex.setMimeType("text/plain");
			documentMsg.getAnnexList().add(annex);
			
			SendMessageRequest request = builder.buildMessage(documentMsg);
			/*
			 * Invoke the business connector framework's eHealthBox's sendMessage operation
			 */
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			SendMessageResponse response = service.sendMessage(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());
			
			
			
		}
		
		
		private java.util.List getDestination() {
			java.util.List addresseeList = new java.util.ArrayList();
			Addressee addressee = new Addressee(IdentifierType.SSIN);
			addressee.setId(TEST_SESSION_USER);
			addressee.setQuality(QualityType.GENERAL_PRACTIONER_SSIN);
			addresseeList.add(addressee);
			
			return addresseeList;
		}
		
		/**
		 * @throws Exception
		 */
		[Test]
		public void testSendDocumentWithNullAnnex()  {
			/*
			 * Create the parameters of the new message
			 */
			SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
			
			DocumentMessage documentMsg = new DocumentMessage();
			documentMsg.setDestinations(getDestination());
			documentMsg.setImportant(false);
			
			documentMsg.setFreeText("Free text:" + UUID.randomUUID());
			
			Document doc = new Document();
			doc.setTitle(documentMsg.getPublicationId() + " Döé\"'(§è!çà)-ument   |; ¢¾ñ");
			doc.setContent(ConnectorIOUtils.getResourceAsStream(FILE_AS_DOC));
			doc.setMimeType("text/plain");
			doc.setFilename("be.ehealth.businessconnector.properties");
			documentMsg.setDocument(doc);
			
			Document annex = new Document();
			annex.setTitle("properties");
			annex.setContent(new byte[]{});
			annex.setFilename("be.ehealth.technicalconnector.properties");
			annex.setMimeType("text/plain");
			documentMsg.getAnnexList().add(annex);
			
			SendMessageRequest request = builder.buildMessage(documentMsg);
			
			/*
			 * Invoke the business connector framework's eHealthBox's sendMessage operation
			 */
			EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
			SendMessageResponse response = service.sendMessage(request);
			
			/*
			 * Verify the response
			 */
			// check if there are no errors
			Assert.AreEqual("100", response.getStatus().getCode());
			// check if a messageId has been returned
			Assert.IsNotNull(response.getId());
			
			
			
		}
		
		
	}
}
