﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.ehealth.businessconnector.chapterIV.integration;
using be.fgov.ehealth.medicalagreement.core.v1;
using java.util;
using NUnit.Framework;
using java.io;
using org.apache.commons.io;
using org.joda.time;
using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.domain;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.businessconnector.chapterIV.testutil;
using be.ehealth.businessconnector.chapterIV.utils;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	/**
	 * Integration test for ChapterIV business connector
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class ChapterIVConsultationIntegrationTest: AbstractChapterIV
	{
		private static bool isTest = true;

		[Test]
			public void testOA100AsDoctor() {
			invoke(".\\examples\\persphysician-chapter4-consultation-request-with-ssin.xml", "81032034303");
		}


		[Test]
			public void testOA500AsDoctor() {
			invoke(".\\examples\\persphysician-chapter4-consultation-request-with-ssin.xml", "76011402195");
		}

		/*[Test]
			public void testOA500AsOrgpharmacy() {
			invoke(".\\examples\\orgpharmacy-chapter4-consultation-request-with-ssin.xml", "76011402195");
		}*/

		/*[Test]
			public void testOA100AsOrgpharmacy() {
			invoke(".\\examples\\orgpharmacy-chapter4-consultation-request-with-ssin.xml", "81032034303", "2686392", "2014-03-01");
		}*/


		private void invoke(String location, String patientInss) {
			invoke(location, patientInss, null, null);
		}

		private void invoke(String location, String patientInss, String cnkValue, String cnkSV) {
			InputStream ins = null;
			try {
				ins = ConnectorIOUtils.getResourceAsStream(location);
				ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();

				FolderType folder = parseFolderType(ins);
				TestUtils.updateAuthor(folder);
				TestUtils.updateTransactionDate(folder, new org.joda.time.DateTime());
				TestUtils.updatePatient(folder, patientInss);
				TestUtils.updateCNK(folder, cnkSV, cnkValue);
				TestUtils.updateReference(folder, UUID.randomUUID().toString());


				ConsultationBuilder builder = BuilderFactory.getBuilderFactoryForSession().getConsultationBuilder();
				ChapterIVBuilderResponse builderResponse = builder.build(folder, isTest, new ChapterIVReferences(true), TestUtils.extractDate(folder));

				ConsultChap4MedicalAdvisorAgreementResponse response = service.consultChap4MedicalAdvisorAgreement(builderResponse.getConsultChap4MedicalAdvisorAgreementRequest());

				ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);

				Assert.IsNotNull(retrievedKmehrResponse);
				Kmehrresponse kmehrresponse = retrievedKmehrResponse.getKmehrresponse();
				Assert.IsNotNull(kmehrresponse);
				Assert.IsNotNull(kmehrresponse.getRequest());
				Assert.IsNotNull(kmehrresponse.getRequest().getKmehrmessage());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampResponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampBytes());
				java.util.List errors = kmehrresponse.getAcknowledge().getErrors();
				Assert.IsTrue(errors.isEmpty(), TestUtils.printErrors(errors));

			} catch (Exception e) {
				process("consult", e);
			} finally {
				IOUtils.closeQuietly(ins);
			}
		}

	}
}
