﻿/*
 * Copyright (c) eHealth
 */
using System;
using be.fgov.ehealth.medicalagreement.core.v1;
using be.fgov.ehealth.standards.kmehr.cd.v1;
using java.lang;
using NUnit.Framework;
using java.io;
using org.joda.time;
using be.ehealth.businessconnector.chapterIV.builders;
using be.ehealth.businessconnector.chapterIV.domain;
using be.ehealth.businessconnector.chapterIV.exception;
using be.ehealth.businessconnector.chapterIV.session;
using be.ehealth.businessconnector.chapterIV.testutil;
using be.ehealth.businessconnector.chapterIV.utils;
using be.ehealth.technicalconnector.exception;
using be.ehealth.technicalconnector.utils;
using be.fgov.ehealth.chap4.protocol.v1;
using be.fgov.ehealth.standards.kmehr.schema.v1;

namespace be.ehealth.businessconnector.chapterIV.integration
{
	/**
	 * Integration test for ChapterIV business connector
	 * 
	 * @author EHP
	 * 
	 */
	[TestFixture]
	public class ChapterIVAdmissionIntegrationTest : AbstractChapterIV
	{

		//Must be doctor to be green

		private static bool isTest = true;

		[Test]
		public void testAdmissionValidRequestOA100() {
			invoke(".\\examples\\persphysician-chapter4-admission-request-with-ssin.xml", "57110204406");
		}


		//[Test]
		public void testAdmissionValidRequestOA100NoAgreementStartdate() {
			invoke(".\\examples\\persphysician-chapter4-admission-request-without-agreementstartdate.xml", "57110204406");
		}


		[Test]
		public void testAdmissionValidRequestOA500() {
			invoke(".\\examples\\persphysician-chapter4-admission-request-with-ssin.xml", "76011402195");
		}

		//[Test]
		public void testAdmissionValidRequestOA500NoAgreementStartdate() {
			invoke(".\\examples\\persphysician-chapter4-admission-request-without-agreementstartdate.xml", "76011402195");
		}


		private void invoke(string location, string patientInss) {

			InputStream ins = null;

			try {
				ins = ConnectorIOUtils.getResourceAsStream(location);
				FolderType folder = parseFolderType(ins);

				TestUtils.updateAuthor(folder);
	            TestUtils.updateTransactionDate(folder, (new org.joda.time.DateTime()).minusMonths(6));
	            TestUtils.updateAgreementDate(folder, (new org.joda.time.DateTime()).minusMonths(6));
				TestUtils.updatePatient(folder, patientInss);

				org.joda.time.DateTime startDate = FolderTypeUtils.retrieveConsultationStartDateOrAgreementStartDate(folder);
				if (startDate == null) {
					startDate = new org.joda.time.DateTime();
				}

				ChapterIVService service = ChapterIVSessionServiceFactory.getChapterIVService();

				ChapterIVReferences references = new ChapterIVReferences(true);
				AdmissionBuilder builder = BuilderFactory.getBuilderFactoryForSession().getAdmissionBuilder();
				ChapterIVBuilderResponse builderResponse = builder.build(folder, isTest, references, startDate);

				AskChap4MedicalAdvisorAgreementResponse response = service.askChap4MedicalAdvisorAgreementResponse(builderResponse.getAskChap4MedicalAdvisorAgreementRequest());
				ChapterIVKmehrResponseWithTimeStampInfo retrievedKmehrResponse = getResponseBuilder().validateTimestampAndretrieveChapterIVKmehrResponseWithTimeStampInfo(response);
				Assert.IsNotNull(retrievedKmehrResponse);
				Kmehrresponse kmehrresponse = retrievedKmehrResponse.getKmehrresponse();
				Assert.IsNotNull(kmehrresponse);
				Assert.IsNotNull(kmehrresponse.getRequest());
				Assert.IsNotNull(kmehrresponse.getRequest().getKmehrmessage());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampResponse());
				Assert.IsNotNull(retrievedKmehrResponse.getKmehrResponseBytes());
				Assert.IsNotNull(retrievedKmehrResponse.getTimeStampBytes());
				java.util.List errors = kmehrresponse.getAcknowledge().getErrors();
				Assert.IsTrue(errors.isEmpty(), TestUtils.printErrors(errors));
			} catch (java.lang.Exception e) {
				process("admission", e);
			} finally {
				ConnectorIOUtils.closeQuietly(ins);
			}
		}
	}
}
