/*
 * Copyright (c) eHealth
 */

#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for TrustStoreUpdater
 */
namespace be.fgov.ehealth.technicalconnector.bootstrap.tsl.signature {

	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.exception;
	using NUnit.Framework;
	using java.lang;
	using be.ehealth.technicalconnector.utils;
	using be.fgov.ehealth.technicalconnector.bootstrap.tsl.signature;
	
	[TestFixture]
	public class TrustStoreUpdaterIntegrationTest
	{
		#region Methods

		[Test]
		public void offline()
		{
			new be.ehealth.technicalconnector.config.impl.ConfigurationModuleXmlSec().init(null);
			
			ConfigFactory.getConfigValidator().setProperty("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location","./P12/int/tslostore.jks");
			ConfigFactory.getConfigValidator().setProperty("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd","tslo");
			
			TrustServiceStatusListSignatureVerifier.reloadCertStore();
			Assert.IsTrue(TrustServiceStatusListSignatureVerifier.isValid(ConnectorIOUtils.getResourceAsString("./int/tsl-ehpbe-person.xml")));
			TrustServiceStatusListSignatureVerifier.reloadCertStore();
			
		}
		
		[Test]
		[ExpectedException(typeof(TechnicalConnectorException))]
		public void online()
		{
			new be.ehealth.technicalconnector.config.impl.ConfigurationModuleXmlSec().init(null);
			
			ConfigFactory.getConfigValidator().setProperty("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.location","./P12/acc/tslostore.jks");
			ConfigFactory.getConfigValidator().setProperty("be.fgov.ehealth.technicalconnector.bootstrap.tsl.keystore.pwd","tslo");
			
			TrustServiceStatusListSignatureVerifier.reloadCertStore();
			Assert.IsTrue(TrustServiceStatusListSignatureVerifier.isValid(ConnectorIOUtils.getResourceAsString("https://tsl-acpt.ehealth.fgov.be/tsl-ehpbe-transport.xml")));
			TrustServiceStatusListSignatureVerifier.reloadCertStore();
			
		}

		#endregion Methods
	}
}
