#region Header

/*
 * Copyright (c) eHealth
 */

#endregion Header

/**
 * IntegrationTest for BeIDInfo
 */
namespace be.ehealth.technicalconnector.beid
{
	using System;
	using System.Security.Cryptography;
	using System.Windows.Forms;

	using be.ehealth.technicalconnector.beid;
	using be.ehealth.technicalconnector.config;
	using be.ehealth.technicalconnector.service.sts.security.impl.beid.impl;
	using be.ehealth.technicalconnector.session;
	using be.ehealth.technicalconnector.utils;
	using be.ehealth.technicalconnector.utils.net;
	using be.fedict.commons.eid.client;

	using java.util;

	using NUnit.Framework;

	[TestFixture]
	public class BeIDInfoUserIntegrationTest
	{
		#region Methods

		public static string ShowDialog(string text, string caption)
		{
			Form prompt = new Form();
			prompt.Width = 500;
			prompt.Height = 150;
			prompt.Text = caption;
			Label textLabel = new Label() { Left = 50, Top=20, Width=400, Text=text };
			TextBox textBox = new TextBox() { Left = 50, Top=50, Width=400 };
			textBox.PasswordChar='*';
			Button confirmation = new Button() { Text = "Ok", Left=350, Width=100, Top=70 };
			confirmation.Click += (sender, e) => { prompt.Close(); };
			prompt.Controls.Add(confirmation);
			prompt.Controls.Add(textLabel);
			prompt.Controls.Add(textBox);
			prompt.ShowDialog();
			return textBox.Text;
		}

		[Test]
		public void customDialog()
		{
			ConfigValidator config =  ConfigFactory.getConfigValidator();
			config.setProperty("beidcardgui.class","be.ehealth.technicalconnector.service.sts.security.impl.beid.impl.BeIDConnectorExternalGui");

			BeIDInfo beIDInfo = BeIDInfo.getInstance("testCustomDialog");
			config.setProperty("user.inss",beIDInfo.getIdentity().getNationalNumber());

			string promptValue = ShowDialog("Pincode", "PinCode requested");
			BeIDConnectorExternalGui externalGui =BeIDConnectorExternalGui.getInstance();
			externalGui.setPIN(PINPurpose.AuthenticationSignature,promptValue.ToCharArray());
			externalGui.setPIN(PINPurpose.NonRepudiationSignature,promptValue.ToCharArray());

			Session.getInstance().createSessionEidOnly();
		}

		/**
		 * Reads the identity card and checks the values received with the values in the properties file
		 * @throws Exception
		 */
		[Test]
		public void readBeID()
		{
			Properties props = TestPropertiesLoader.getProperties(".\\be.ehealth.technicalconnector.test.properties",".net");
			
			BeIDInfo beIDInfo = BeIDInfo.getInstance("test");

			Assert.AreEqual(props.getProperty("test.session.firstname"), beIDInfo.getIdentity().getFirstName());
			Assert.AreEqual(props.getProperty("test.session.lastname"), beIDInfo.getIdentity().getName());
			
			Console.WriteLine("FirstName"+ beIDInfo.getIdentity().getFirstName());
		}

		#endregion Methods
	}
}