package be.fgov.ehealth.technicalconnector.tests.junit.rule;

import org.junit.rules.ExternalResource;

import be.ehealth.technicalconnector.config.ConfigFactory;
import be.fgov.ehealth.technicalconnector.bootstrap.bcp.EndpointUpdater;

public class EndpointUpdateRule extends ExternalResource {

    private String location;

    public EndpointUpdateRule(String location) {
        this.location = location;
    }


    @Override
    protected void before() throws Throwable {
        ConfigFactory.getConfigValidator().setProperty("crypto.revocationstatuschecker.classname", "be.ehealth.technicalconnector.service.etee.impl.ConnectorMockRevocationStatusChecker");
        ConfigFactory.getConfigValidator().setProperty("be.ehealth.technicalconnector.bcp.status.endpoint", location);
        ConfigFactory.getConfigValidator().setProperty("connector.soaphandler.connection.request.timeout", "100");
        EndpointUpdater.update();
    }


    @Override
    protected void after() {
        EndpointUpdater.reset();
    }

}
