/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.recipe.validators.impl;

import java.io.InputStream;

import org.junit.Test;

import be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException;
import be.ehealth.technicalconnector.utils.ConnectorIOUtils;


/**
 * Test class for {@link KmehrValidatorImpl}
 * 
 * @author EHP
 * 
 */
@Deprecated
public class KmehrValidatorImplTest {

    /**
     * Verifies the validity of a kmehr resource
     * 
     * @throws Exception
     */
    @Test
    public void testValidPrescription() throws Exception {
        KmehrValidatorImpl validator = new KmehrValidatorImpl();
        InputStream is = KmehrValidatorImplTest.class.getResourceAsStream("/examples/sample-prescription.xml");
        validator.validateKmehrPrescription(ConnectorIOUtils.getBytes(is), "P0");

    }

    /**
     * Verifies the validity of a kmehr resource (resource is invalid)
     * 
     * @throws Exception
     */
    @Test(expected = RecipeBusinessConnectorException.class)
    public void testInValidPrescription() throws Exception {
        KmehrValidatorImpl validator = new KmehrValidatorImpl();
        InputStream is = KmehrValidatorImplTest.class.getResourceAsStream("/examples/sample-prescription-wrong.xml");
        validator.validateKmehrPrescription(ConnectorIOUtils.getBytes(is), "P0");
    }

    /**
     * Verifies the validity of a kmehr resource
     * 
     * @throws Exception
     */
    @Test
    public void testValidNotification() throws Exception {
        KmehrValidatorImpl validator = new KmehrValidatorImpl();
        InputStream is = KmehrValidatorImplTest.class.getResourceAsStream("/examples/sample-notification.xml");
        validator.validateNotification(ConnectorIOUtils.getBytes(is));

    }

    /**
     * Verifies the validity of a kmehr resource
     * 
     * @throws Exception
     */
    @Test
    public void testValidFeedback() throws Exception {
        KmehrValidatorImpl validator = new KmehrValidatorImpl();
        InputStream is = KmehrValidatorImplTest.class.getResourceAsStream("/examples/sample-feedback.xml");
        validator.assertValidFeedback(ConnectorIOUtils.getBytes(is));

    }
}
