/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.recipe.exception;

import static org.junit.Assert.assertEquals;

import java.text.MessageFormat;

import org.junit.Test;


/**
 * Test class for {@link RecipeBusinessConnectorException}
 * 
 * @author EHP
 * 
 */
@Deprecated
public class RecipeConnectorExceptionTest {

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException#RecipeConnectorException(be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorExceptionValues, java.lang.Object[])}
     * .
     */
    @Test
    public void testRecipeConnectorExceptionRecipeConnectorExceptionValuesObjectArray() {
        RecipeBusinessConnectorExceptionValues errorValue = RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID;
        RecipeBusinessConnectorException error = new RecipeBusinessConnectorException(errorValue);
        assertEquals(error.getErrorCode(), RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID.getErrorCode());
        assertEquals(error.getMessage(), RecipeBusinessConnectorExceptionValues.ERROR_XML_INVALID.getMessage());
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException#RecipeConnectorException(be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorExceptionValues, java.lang.Throwable, java.lang.Object[])}
     * .
     */
    @Test
    public void testRecipeConnectorExceptionRecipeConnectorExceptionValuesParam() {
        RecipeBusinessConnectorExceptionValues errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL;
        RecipeBusinessConnectorException error = new RecipeBusinessConnectorException(errorValue, "test");
        assertEquals(error.getErrorCode(), RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getErrorCode());
        assertEquals(error.getMessage(), MessageFormat.format(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage(), "test"));
    }

    /**
     * Test method for
     * {@link be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorException#RecipeConnectorException(be.ehealth.businessconnector.recipe.exception.RecipeBusinessConnectorExceptionValues, java.lang.Throwable, java.lang.Object[])}
     * .
     */
    @Test
    public void testRecipeConnectorExceptionRecipeConnectorExceptionValuesThrowable() {
        RecipeBusinessConnectorExceptionValues errorValue = RecipeBusinessConnectorExceptionValues.ERROR_GENERAL;
        RecipeBusinessConnectorException error = new RecipeBusinessConnectorException(errorValue, new Throwable(), "test");
        assertEquals(error.getErrorCode(), RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getErrorCode());
        assertEquals(error.getMessage(), MessageFormat.format(RecipeBusinessConnectorExceptionValues.ERROR_GENERAL.getMessage(), "test"));
    }

}
