/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.hub.session;

import java.util.List;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import be.ehealth.business.kmehrcommons.helper.ErrorTypeManagement;
import be.ehealth.businessconnector.hub.exception.IntraHubBusinessConnectorException;
import be.ehealth.technicalconnector.config.ConfigFactory;
import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.fgov.ehealth.hubservices.core.v1.ConsentType;
import be.fgov.ehealth.hubservices.core.v1.PutTransactionResponse;
import be.fgov.ehealth.hubservices.core.v1.TherapeuticLinkType;
import be.fgov.ehealth.hubservices.core.v1.TransactionIdType;
import be.fgov.ehealth.standards.kmehr.schema.v1.ErrorType;
import be.fgov.ehealth.standards.kmehr.schema.v1.FolderType;
import be.fgov.ehealth.standards.kmehr.schema.v1.Kmehrmessage;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * Test for specific case
 * 
 * @author EHP
 */
public class SpecificHubIntegrationTest extends AbstractIntrahubIntegrationTest {

    private static ConsentType consent;

    private static TherapeuticLinkType therapeuticLink;

    @BeforeClass
    public static void initConsent() throws ConnectorException {
        consent = createConsentType();
        hubServiceComplete.putPatientConsent(consent);

        therapeuticLink = createTherapeuticLinkType();
        hubServiceComplete.putTherapeuticLink(therapeuticLink);
    }

    @AfterClass
    public static void teardownConsent() throws TechnicalConnectorException, IntraHubBusinessConnectorException {
        therapeuticLink.setEnddate(new DateTime());
        hubServiceComplete.revokeTherapeuticLink(therapeuticLink);

        consent.setRevokedate(new DateTime());
        hubServiceComplete.revokePatientConsent(consent);


    }

    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionRSW() throws Exception {
        testPutTransaction(URL_RSW);
    }


    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    @Ignore("method not supported by kul")
    public void testSessionPutTransactionKul() throws Exception {
        testPutTransaction(URL_VZNKUL);
    }

    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionCozo() throws Exception {
        testPutTransaction(URL_COZO);
    }

    /**
     * Test for the jira EHCON-666 Without session and after with one
     * 
     * @throws Exception
     */
    @Test
    public void testSessionPutTransactionARH() throws Exception {
        testPutTransaction(URL_ARH);
    }


    /**
     * @throws Exception
     * @throws IntraHubBusinessConnectorException
     * @throws TechnicalConnectorException
     */
    private void testPutTransaction(String url) throws Exception, IntraHubBusinessConnectorException, TechnicalConnectorException {
        Session.getInstance().unloadSession();
        ConfigFactory.getConfigValidator().setProperty("endpoint.hub.intra", url);

        Kmehrmessage transactionToPut = new Kmehrmessage();
        transactionToPut.setHeader(createHeader());
        FolderType folder = new FolderType();
        folder.getIds().add(createMessageId("1"));
        folder.setPatient(createPatientForTransaction());
        folder.getTransactions().add(createTransactionType());
        transactionToPut.getFolders().add(folder);

        try {
            hubServiceComplete.putTransaction(transactionToPut);
            Assert.fail("Must throw a 'No active session found' exception");
        } catch (TechnicalConnectorException e) {
            Assert.assertEquals("No active session found", e.getMessage());
        }

        SessionInitializer.init("/be.ehealth.businessconnector.intrahub.test.properties");
        ConfigFactory.getConfigValidator().setProperty("endpoint.hub.intra", url);

        PutTransactionResponse putTransaction = hubServiceComplete.putTransaction(transactionToPut);

        TransactionIdType transid = new TransactionIdType();
        transid.getIds().add(createTransactionId(transactionId));
        hubServiceComplete.revokeTransaction(createPatientIdType(), transid);

        List<ErrorType> errors = putTransaction.getAcknowledge().getErrors();
        Assert.assertTrue(ErrorTypeManagement.printErrors(errors), errors.isEmpty());
    }
}
