/*
 * Copyright (c) Smals
 */
package be.ehealth.businessconnector.ehboxV2.testutil;

import java.util.List;

import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.domain.exception.EhboxBusinessConnectorException;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehboxV2.session.ServiceFactory;
import be.ehealth.technicalconnector.exception.SessionManagementException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.idgenerator.IdGeneratorFactory;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessageListResponseType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.GetMessagesListRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.Message;


/**
 * utility class for tests.
 * 
 * @author EHP
 * 
 */
public class EhboxTestUtil {

    private static final Logger LOG = LoggerFactory.getLogger(EhboxTestUtil.class);

    /**
     * fixed test values to use.
     */
    public static final String ANNEX_MIME_TYPE = "annex mimeType";

    /**
     * fixed test values to use.
     */
    public static final String ANNEX_TITLE = "annex title";

    /**
     * fixed test values to use.
     */
    public static final String ANNEX_FILENAME = "annex filename";

    /**
     * fixed test values to use.
     */
    public static final String PATIENT_INSS = "patientInss";

    /**
     * fixed test values to use.
     */
    public static final QualityType MANDATEE_QUALITY = QualityType.PHARMACY_NIHII;

    /**
     * fixed test values to use.
     */
    public static final String MANDATEE_ID = "1";

    /**
     * fixed test values to use.
     */
    public static final String MANDATEE_APPLICATION_ID = "MANDATEE_APPLICATION_ID";

    /**
     * fixed test values to use.
     */
    public static final String TITLE = "title";

    /**
     * fixed test values to use.
     */
    public static final String MIME_TYPE = "mimeType";

    /**
     * fixed test values to use.
     */
    public static final QualityType QUALITY = QualityType.GENERAL_PRACTIONER_SSIN;

    /**
     * fixed test values to use.
     */
    public static final String ORGANIZATION_NAME = "organizationName";

    /**
     * fixed test values to use.
     */
    public static final String LAST_NAME = "lastName";

    /**
     * fixed test values to use.
     */
    public static final String ID = "82051234978";

    /**
     * fixed test values to use.
     */
    public static final String FIRST_NAME = "firstName";

    /**
     * fixed test values to use.
     */
    public static final String APPLICATION_ID = "applicationId";

    /**
     * fixed test values to use.
     */
    public static final String FILENAME = "newFilename";

    /**
     * fixed test values to use.
     */
    public static final String FREE_TEXT = "freeText";

    /**
     * @return we use deprecated methods ( test for ehbox v2, methods are deprecated for v3 )
     */
    @SuppressWarnings("deprecation")
    public static DocumentMessage<Message> createFilledDocumentMessage(String testIdentifier) {
        DocumentMessage<Message> message = new DocumentMessage<Message>();
        message.setFreeText(EhboxTestUtil.FREE_TEXT);

        message.setPatientInss(EhboxTestUtil.PATIENT_INSS);


        // mandatee
        message.setMandatee(new Addressee(EhboxTestUtil.MANDATEE_QUALITY.getIdentifierType()));
        message.getMandatee().setApplicationId(EhboxTestUtil.MANDATEE_APPLICATION_ID);
        message.getMandatee().setId(EhboxTestUtil.MANDATEE_QUALITY.getIdentifierType().formatIdentifierValue(Long.parseLong(EhboxTestUtil.MANDATEE_ID)));
        message.getMandatee().setQuality(EhboxTestUtil.MANDATEE_QUALITY);

        // destination
        // using a doctor with ssin as destination , so no organisation name and application id
        Addressee destinationToUse = new Addressee(EhboxTestUtil.QUALITY.getIdentifierType());
        // destinationToUse.setApplicationId(EhboxTestUtil.APPLICATION_ID);
        destinationToUse.setFirstName(EhboxTestUtil.FIRST_NAME);
        destinationToUse.setId(EhboxTestUtil.ID);
        destinationToUse.setLastName(EhboxTestUtil.LAST_NAME);
        // destinationToUse.setOrganizationName(EhboxTestUtil.ORGANIZATION_NAME);
        destinationToUse.setQuality(EhboxTestUtil.QUALITY);
        message.getDestinations().add(destinationToUse);

        //
        message.setImportant(true);
        message.setEncrypted(true);

        // document
        message.setDocument(new Document());
        message.getDocument().setFilename(EhboxTestUtil.FILENAME);
        message.getDocument().setMimeType(EhboxTestUtil.MIME_TYPE);
        message.getDocument().setTitle(EhboxTestUtil.TITLE + " " + testIdentifier);
        message.getDocument().setContent("blabla".getBytes());
        // message.getDocument().setException(new UnsealConnectorException(UnsealConnectorExceptionValues.ERROR_CRYPTO, (Throwable) null,
        // "Content is null"));

        // annex
        Document annex = new Document();
        annex.setFilename(EhboxTestUtil.ANNEX_FILENAME);
        annex.setMimeType(EhboxTestUtil.ANNEX_MIME_TYPE);
        annex.setTitle(EhboxTestUtil.ANNEX_TITLE);
        annex.setContent("blabla".getBytes());

        message.getAnnexList().add(annex);
        return message;
    }

    /**
     * @return
     * @throws TechnicalConnectorException
     */
    public static String generatePublicationId() throws TechnicalConnectorException {
        String generatedId = IdGeneratorFactory.getIdGenerator().generateId();
        String truncatedId = generatedId.substring(1, 13);
        return truncatedId;
    }

    public static List<Message> getInboxMessages() throws SessionManagementException, TechnicalConnectorException, EhboxBusinessConnectorException {
        return getMessagesForSource("INBOX");
    }

    public static List<Message> getMessagesForSource(String source) throws SessionManagementException, TechnicalConnectorException, EhboxBusinessConnectorException {
        GetMessagesListRequest request = new GetMessagesListRequest();
        request.setSource(source);
        GetMessageListResponseType messageList = ServiceFactory.getEhealthBoxServiceV2().getMessageList(request);
        Assert.assertTrue("100".equals(messageList.getStatus().getCode()));
        return messageList.getMessages();
    }

    /**
     * @param messages the messages to log
     * @throws EhboxBusinessConnectorException
     * @throws TechnicalConnectorException
     * @throws SessionManagementException
     * 
     */
    public static void logMessages(List<Message> messages) throws SessionManagementException, TechnicalConnectorException, EhboxBusinessConnectorException {
        StringBuilder sb = new StringBuilder();
        for (Message message : messages) {
            logMessage(message, sb);
        }
        LOG.debug("logMessages : messages in list are : " + sb.toString());
    }

    /**
     * @param message
     */
    private static void logMessage(Message message, StringBuilder sb) {

        sb.append("\n");
        sb.append("messageId").append(message.getMessageId()).append(" ");
        sb.append("type").append(message.getContentInfo().getContentType()).append(" ");
        sb.append("title").append(message.getContentInfo().getTitle()).append(" ");
        sb.append("applicationName").append(message.getContentSpecification().getApplicationName()).append(" ");
        sb.append("publicationDate").append(message.getMessageInfo().getPublicationDate()).append(" ");
        sb.append("size").append(message.getMessageInfo().getSize()).append(" ");

    }

}
