/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.ehboxV2.session;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.DocumentMessage;
import be.ehealth.businessconnector.ehbox.api.domain.NewsMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehboxV2.AbstractEhboxV2IntegrationTest;
import be.ehealth.businessconnector.ehboxV2.builders.BuilderFactory;
import be.ehealth.businessconnector.ehboxV2.builders.SendMessageBuilder;
import be.ehealth.businessconnector.ehboxV2.testutil.EhboxTestUtil;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageResponse;


/**
 * Integration test for loading/unloading or reloading session from token
 * 
 * @author EHP
 * 
 */
public class LoadUnloadSessionIntegrationTest extends AbstractEhboxV2IntegrationTest {

    private static final Logger LOG = LoggerFactory.getLogger(LoadUnloadSessionIntegrationTest.class);

    private static final String TEST_SESSION_USER = "82051234978";

    private static final String FILE_AS_DOC = "/LOREM_IPSUM.txt";

    /**
     * 
     * @throws Exception
     */
    @Before
    public void testSendNewsMessage() throws Exception {
        /*
         * Create the parameters of the new message
         */
        SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();


        NewsMessage<Message> news = new NewsMessage<Message>();
        news.getDocument().setTitle("News " + new Date());
        news.getDocument().setContent("eureka".getBytes());

        news.setDestinations(getDestination());
        news.setImportant(true);
        news.setEncrypted(false);

        SendMessageRequest request = builder.buildMessage(news);


        /*
         * Invoke the business connector framework's eHealthBox's sendMessage operation
         */
        EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
        SendMessageResponse response = service.sendMessage(request);

        /*
         * Verify the response
         */
        // check if there are no errors
        Assert.assertEquals("100", response.getStatus().getCode());
        // check if a messageId has been returned
        Assert.assertNotNull(response.getId());

        LOG.debug("Message Sent: " + response.getId());

    }

    @Test
    public void testSendEncryptedDocumentWithAnnex() throws Exception {
        /*
         * Create the parameters of the new message
         */
        Assert.assertNotNull("crypto in session should not be null", Session.getInstance().getSession().getEncryptionCrypto());
        SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();
        Assert.assertNotNull(builder);

        DocumentMessage<Message> documentMsg = new DocumentMessage<Message>();
        documentMsg.setDestinations(getDestination());
        documentMsg.setImportant(false);
        documentMsg.setEncrypted(true);

        documentMsg.setFreeText("Free text:" + UUID.randomUUID());
        documentMsg.setPatientInss(TEST_SESSION_USER);

        Document doc = new Document();
        doc.setTitle(this.getClass().getCanonicalName() + "testSendEncryptedDocumentWithAnnex Encrypted document " + new Date());
        doc.setContent(EhboxV2ServicePublicationIntegrationTest.class.getResourceAsStream(FILE_AS_DOC));
        doc.setMimeType("text/plain");
        doc.setFilename("be.ehealth.businessconnector.properties");
        documentMsg.setDocument(doc);

        Document annex = new Document();
        annex.setTitle("properties");
        annex.setContent(EhboxV2ServicePublicationIntegrationTest.class.getResourceAsStream(FILE_AS_DOC));
        annex.setFilename("be.ehealth.technicalconnector.properties");
        annex.setMimeType("text/plain");
        documentMsg.getAnnexList().add(annex);

        SendMessageRequest request = builder.buildMessage(documentMsg);
        /*
         * Invoke the business connector framework's eHealthBox's sendMessage operation
         */
        EhealthBoxServiceV2 service = ServiceFactory.getEhealthBoxServiceV2();
        SendMessageResponse response = service.sendMessage(request);

        /*
         * Verify the response
         */
        // check if there are no errors
        Assert.assertEquals("100", response.getStatus().getCode());
        // check if a messageId has been returned
        Assert.assertNotNull(response.getId());

        LOG.debug("Message Sent: " + response.getId());

        EhboxTestUtil.logMessages(EhboxTestUtil.getInboxMessages());


    }

    private List<Addressee> getDestination() {
        List<Addressee> addresseeList = new ArrayList<Addressee>();
        Addressee addressee = new Addressee(IdentifierType.SSIN);
        addressee.setId(TEST_SESSION_USER);
        addressee.setQuality(QualityType.GENERAL_PRACTIONER_SSIN);
        addresseeList.add(addressee);

        return addresseeList;
    }

}
