/*
 * Copyright (c) Smals
 */
package be.ehealth.businessconnector.ehboxV2.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import org.junit.Test;

import be.ehealth.businessconnector.ehbox.api.domain.Addressee;
import be.ehealth.businessconnector.ehbox.api.domain.Document;
import be.ehealth.businessconnector.ehbox.api.domain.NewsMessage;
import be.ehealth.businessconnector.ehbox.api.utils.QualityType;
import be.ehealth.businessconnector.ehboxV2.builders.BuilderFactory;
import be.ehealth.businessconnector.ehboxV2.builders.SendMessageBuilder;
import be.ehealth.businessconnector.ehboxV2.testutil.EhboxTestUtil;
import be.ehealth.technicalconnector.handler.SchemaValidatorHandler;
import be.ehealth.technicalconnector.utils.IdentifierType;
import be.ehealth.technicalconnector.ws.domain.GenericRequest;
import be.fgov.ehealth.ehbox.consultation.protocol.v2.Message;
import be.fgov.ehealth.ehbox.publication.protocol.v2.SendMessageRequest;


/**
 * Test if the xml is valid through the xsd
 * 
 * @author EHP
 * 
 */
public class XsdValidationTest {

    /**
     * XSD files
     */
    private static final String XML = "/XSD/external/xml.xsd";

    private static final String EH_COMMONS_PROT = "/XSD/common/ehealth-commons-schema-protocol-1_6.xsd";

    private static final String EH_COMMONS_CORE = "/XSD/common/ehealth-commons-schema-core-1_6.xsd";

    private static final String ERROR_SOA_CORE = "/XSD/common/ehealth-errors-schema-core-1_0.xsd";

    private static final String ERROR_SOA = "/XSD/common/ehealth-errors-schema-soa-1_0.xsd";

    private static final String EHBOX_CONS_PROT = "/XSD/ehbox_v2/ehealth-ehBox-consultation-schema-protocol-2_0.xsd";

    private static final String EHBOX_PUB_PROT = "/XSD/ehbox_v2/ehealth-ehBox-publication-schema-protocol-2_0.xsd";

    private static final String EHBOX_CORE = "/XSD/ehbox_v2/ehealth-ehBox-schema-core-2_0.xsd";

    protected static final String[] EHBOXV2_PUB_XSD = {
        EHBOX_PUB_PROT
    };

    SchemaValidatorHandler handler = new SchemaValidatorHandler(SchemaValidatorHandler.VERIFY_OUTBOUND, EHBOXV2_PUB_XSD);

    @Test
    public void testValidation() throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);


        SendMessageBuilder builder = BuilderFactory.getSendMessageBuilder();


        NewsMessage<Message> news = new NewsMessage<Message>();
        news.setPublicationId(EhboxTestUtil.generatePublicationId());
        Document newsDocument = new Document();
        news.setDocument(newsDocument);
        newsDocument.setTitle("Encrypted news " + new Date());
        newsDocument.setContent("eureka".getBytes());
        newsDocument.setMimeType("text/xml");

        news.setDestinations(getDestination());
        news.setImportant(true);
        news.setEncrypted(false);

        SendMessageRequest request = builder.buildMessage(news);

        request.setPublicationId("15");

        GenericRequest genRequest = new GenericRequest();
        genRequest.setPayload(request);

        URL schemaurl = SchemaValidatorHandler.class.getResource(EHBOXV2_PUB_XSD[0]);
        Schema schema = schemaFactory.newSchema(schemaurl);
        Validator newValidator = schema.newValidator();
        DOMSource source = new DOMSource(genRequest.getPayload());
        newValidator.validate(source);

    }

    /**
     * Returns the destination
     * 
     * @return
     */
    private List<Addressee> getDestination() {
        List<Addressee> addresseeList = new ArrayList<Addressee>();
        Addressee addressee = new Addressee(IdentifierType.SSIN);
        addressee.setId("82051234978");
        addressee.setQuality(QualityType.GENERAL_PRACTIONER_SSIN);
        addresseeList.add(addressee);

        return addresseeList;
    }

}
