/*
 * Copyright (c) eHealth
 */
package be.ehealth.businessconnector.dics.session;

import static org.junit.Assert.assertTrue;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import be.ehealth.technicalconnector.exception.ConnectorException;
import be.ehealth.technicalconnector.exception.TechnicalConnectorException;
import be.ehealth.technicalconnector.session.Session;
import be.ehealth.technicalconnector.session.SessionManager;
import be.ehealth.technicalconnector.testcommons.SessionTestUtils;
import be.fgov.ehealth.dics.protocol.v1.FindCNKRequest;
import be.fgov.ehealth.technicalconnector.tests.session.SessionInitializer;


/**
 * 
 * @author EH076
 * 
 * @since
 * 
 */
public class DicsSessionServiceFactoryTest {


    private SessionManager noSessionManager;


    @Before
    public void initialize() throws Exception {
        SessionInitializer.init("/be.ehealth.businessconnector.dics.test.properties", false);
        noSessionManager = EasyMock.createNiceMock(SessionManager.class);
    }


    /**
     * Test method for {@link be.ehealth.businessconnector.dics.session.DicsSessionServiceFactory#getTarificationSession()}.
     */
    @Test
    public void testGetTarificationSession() throws ConnectorException {
        try {
            Session.setSessionManager(SessionTestUtils.getDummySessionManager());
            DicsSessionService tarificationSession = DicsSessionServiceFactory.getTarificationSession();
            Assert.assertNotNull(tarificationSession);
        } finally {
            Session.setSessionManager(null);
        }

    }

    /**
     * Test method for {@link be.ehealth.businessconnector.dics.session.DicsSessionServiceFactory#getTarificationSession()}.
     */
    @Test
    public void testCallTarificationSessionWithoutSession() throws ConnectorException {
        try {
            Session.setSessionManager(noSessionManager);
            EasyMock.expect(noSessionManager.hasValidSession()).andReturn(false);
            EasyMock.replay(noSessionManager);
            DicsSessionService tarificationSession = DicsSessionServiceFactory.getTarificationSession();
            tarificationSession.findCNK(new FindCNKRequest());
            Assert.fail("should have thrown exception because there is no Session active");
        } catch (TechnicalConnectorException e) {
            Assert.assertEquals("No active session found", e.getMessage());
        }
    }


    @Test
    public void testConstructorIsPrivate() throws Exception {

        Constructor<DicsSessionServiceFactory> constructor = DicsSessionServiceFactory.class.getDeclaredConstructor();
        assertTrue("Constructor is not private", Modifier.isPrivate(constructor.getModifiers()));

        constructor.setAccessible(true);
        try {
            constructor.newInstance();
            Assert.fail("should have thrown UnsupportedOperationException");
        } catch (InvocationTargetException e) {
            Assert.assertTrue(e.getTargetException() instanceof UnsupportedOperationException);
        }
    }

}
